% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_EAP_by_array.R
\name{extract_EAP_by_array}
\alias{extract_EAP_by_array}
\title{Extract Etimates Preserving Array Format.}
\usage{
extract_EAP_by_array(StanS4class, name.of.parameter)
}
\arguments{
\item{StanS4class}{fitted model object, from an output of \code{rstan::sampling()}.}

\item{name.of.parameter}{An parameter name (given as a character string, should not surround by "").
The name of parameter which user want to extract.
Parameters are contained in the parameter block of each Stan file in the path: inst/extdata.}
}
\value{
A list of datalists from the posterior predictive distribution
}
\description{
Extract EAP extimates by array format.
}
\details{
If an estimate is an array,
then this function extract  estimated parameters preserving an array format.
The \code{rstan} also has such function,
i.e., \strong{\emph{\code{rstan::\link[rstan]{get_posterior_mean}}()}}.
 However this function does not extract paramter as an array but coerce to the class matrix.
}
\examples{
 \donttest{
#=================================The first example: MRMC case ========================
# Make a fitted model object of class stanfitExtended
# which is inherited from the S4class stanfit.
# The following example, fitted model is the hierarchical Bayesian FROC model
# which is used to compare modality.

 fit <- fit_Bayesian_FROC( ite  = 1111 ,
                           summary = FALSE   ,
                           dataList = dataList.Chakra.Web.orderd,cha=1
                            )

#  Extract one dimensional array "z = z[]",

                  z   <- extract_EAP_by_array(
                                               fit,  # The above fitted model object
                                               z     # The parameter contained in "fit"
                                               )



#  Extract two dimensional array "AA = AA[ , ]",

                  AA  <- extract_EAP_by_array(
                                              fit,
                                              AA
                                              )


#  Extract three dimensional array "ppp = ppp[ , , ]",

                  ppp <- extract_EAP_by_array(fit,ppp)



# ####1#### ####2#### ####3#### ####4#### ####5#### ####6#### ####7#### ####8#### ####9####
#================= The second example: singler reader and single modality ==============



#   Of course, for the case of srsc, it is also available.
#   We shall show the case of srsc in which case the parameters are not array,
#   but in such a case we can extract estimates preserving its format such as vector.

 fit <- fit_Bayesian_FROC( ite  = 1111 ,
                           summary = FALSE   ,
                           dataList = dataList.Chakra.1,
                           cha=2
                            )

#  To extract the posterior mean for parameter "A" representing AUC, we run the following;


          A <- extract_EAP_by_array(
                                    fit,
                                     A
                                     )




#  To extract the posterior mean for parameter "z" indicating decision thresholds;


          z <- extract_EAP_by_array(
                                     fit,
                                     z
                                     )



# 2019.05.21 Revised.
}# dottest

}
