% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewdata.R
\name{viewdata}
\alias{viewdata}
\title{Build a table of FROC data}
\usage{
viewdata(dataList, summary = TRUE)
}
\arguments{
\item{dataList}{------------------------------------------------------


  Single reader and single modality (SRSC) case.


------------------------------------------------------

In single reader and single modality case, it should include  \code{f, h, NL, NI, C}.
The detail of these dataset, see the datasets  endowed with this package.
Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
its each confidence level should not included  your data. So, to confirm
your false positives and hits are correctly correspondence
to confidence levels,
you should confirm the orders by the function

----------------------------------------------------------------------------

  Multiple readers and multiple modalities case, i.e., MRMC case


----------------------------------------------------------------------------


In  multiple readers and multiple modalities case, i.e., MRMC case,
it should include  \code{m,q,c,h,f,NL,C,M,Q} which means from the right

\code{C } means the highest number of confidence level, this is a scalar.

\code{M } means the number of modalities

\code{Q } means the number of readers.

\code{c } means the confidence level vector. This vector must be made by \code{rep(rep(C:1), M*Q)}.


\code{m } means the modality ID vector.

\code{q } means the reader ID vector.


\code{h } means the number of hits vector.

\code{f } means the number of false alarm vector.

\code{NL } means the Total number of lesions for all images, this is a scalar.

The detail of these dataset, please see the endowed datasets.
Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
its each confidence level vector also created in the program by \code{C}. So, to confirm
your false positives and hits are correctly correspond
to confidence levels,
you should confirm the orders by the function \code{viewdata_MRMC}.}

\item{summary}{TRUE or FALSE, if true then results are printed, if FALSE this function do nothing.}
}
\value{
Nothing

In order to confirm your data, please view table before fitting.
Confidence level vector are created in my program regardless of user's confidence level vectors.
}
\description{
Create a tabular representation of FROC data from FROC data object.
}
\examples{
\donttest{

# The first example, we prepare the data endowed with this package.
             dat  <- get(data("dataList.Chakra.1"))




             viewdata(dat)


# The second examle, we consider the multiple reader and multiple dataset

             dat <-  get(data("dataList.Chakra.Web"))

             viewdata(dat)


}# dottest

}
