% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classBayesianOutput.R
\name{getSample}
\alias{getSample}
\title{Extracts the sample from a bayesianOutput}
\usage{
getSample(sampler, parametersOnly = T, coda = F, start = 1, end = NULL,
  thin = 1, numSamples = NULL, whichParameters = NULL,
  reportDiagnostics = FALSE, ...)
}
\arguments{
\item{sampler}{an object of class mcmcSampler, mcmcSamplerList, smcSampler, smcSamplerList}

\item{parametersOnly}{if F, likelihood, posterior and prior values are also provided in the output}

\item{coda}{works only for mcmc classes - provides output as a coda object. Note: if mcmcSamplerList contains mcmc samplers such as DE that have several chains, the internal chains will be collapsed. This may not be the desired behavior for all applications.}

\item{start}{for mcmc samplers start value in the chain. For SMC samplers, start particle}

\item{end}{for mcmc samplers end value in the chain. For SMC samplers, end particle}

\item{thin}{thinning parameter. Either an integer determining the thinning intervall (default is 1) or "auto" for automatic thinning.}

\item{numSamples}{sample size (only used if thin = 1)}

\item{whichParameters}{possibility to select parameters by index}

\item{reportDiagnostics}{logical, determines whether settings should be included in the output}

\item{...}{further arguments}
}
\description{
Extracts the sample from a bayesianOutput
}
\examples{
ll = function(x) sum(dnorm(x, log = TRUE))

setup = createBayesianSetup(ll, lower = c(-10,-10), upper = c(10,10))

settings = list(nrChains = 2, iterations = 1000)
out <- runMCMC(bayesianSetup = setup, sampler = "DEzs", settings = settings)


# population MCMCs divide the interations by the number of internal chains,
# so the end of the 3 chains is 1000/3 = 334
sample <- getSample(out, start = 100, end = 334, thin = 10) 

# 
sample <- getSample(out, start = 100, numSamples = 60, coda = TRUE)
plot(sample)
}
\author{
Florian Hartig
}
