% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMarginals.R
\name{marginalPlot}
\alias{marginalPlot}
\title{Plot MCMC marginals}
\usage{
marginalPlot(x, prior = FALSE, xrange = NULL, type = "d",
  singlePanel = TRUE, settings = NULL, nPriorDraws = 10000, ...)
}
\arguments{
\item{x}{bayesianOutput, or matrix or data.frame containing with samples as rows and parameters as columns}

\item{prior}{logical determining whether the prior should be plotted, or if x is matrix oder data.frame, a matrix of prior draws with draws as rows and parameters as columns}

\item{xrange}{vector or matrix of plotting ranges for the x axis. If matrix, the rows must be parameters and the columns min and max values.}

\item{type}{character determining the plot type. Either 'd' for density plot, or 'v' for violin plot}

\item{singlePanel}{logical, determining whether the parameter should be plotted in a single panel or each in its own panel}

\item{settings}{optional list of additional settings for \code{\link{marginalPlotDensity}}, and \code{\link{marginalPlotViolin}}, respectively}

\item{nPriorDraws}{number of draws from the prior, if x is bayesianOutput}

\item{...}{additional arguments passed to \code{\link{getSample}}. If you have a high number of draws from the posterior it is advised to set numSamples (to e.g. 5000) for performance reasons.}
}
\description{
Plot MCMC marginals
}
\examples{
## Generate a test likelihood function. 
ll <- generateTestDensityMultiNormal(sigma = "no correlation")

## Create a BayesianSetup
bayesianSetup <- createBayesianSetup(likelihood = ll, lower = rep(-10, 3), upper = rep(10, 3))

## Finally we can run the sampler and have a look
settings = list(iterations = 1000, adapt = FALSE)
out <- runMCMC(bayesianSetup = bayesianSetup, sampler = "Metropolis", settings = settings)

marginalPlot(out, prior = TRUE)

## We can plot the marginals in several ways:
## violin plots
marginalPlot(out, type = 'v', singlePanel = TRUE) 
marginalPlot(out, type = 'v', singlePanel = FALSE)
marginalPlot(out, type = 'v', singlePanel = TRUE, prior = TRUE)

## density plot
marginalPlot(out, type = 'd', singlePanel = TRUE) 
marginalPlot(out, type = 'd', singlePanel = FALSE)
marginalPlot(out, type = 'd', singlePanel = TRUE, prior = TRUE)

## if you have a very wide prior you can use the xrange option to plot only
## a certain parameter range
marginalPlot(out, type = 'v', singlePanel = TRUE, xrange = matrix(rep(c(-5, 5), 3), ncol = 3))

##Further options
# We can pass arguments to getSample (check ?getSample) and to the density and violin plots
marginalPlot(out, type = 'v', singlePanel = TRUE, 
             settings = list(col = c('#FC006299','#00BBAA88')), prior = TRUE)
marginalPlot(out, type = 'v', singlePanel = TRUE, numSamples = 500)
}
\author{
Tankred Ott
}
