/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.statistics;

import dr.evomodel.antigenic.phyloclustering.TreeClusteringVirusesPrior;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class DriverCountStatistic
extends Statistic.Abstract
implements VariableListener {
    public static final String DRIVERCOUNT_STATISTIC = "driverCountStatistic";
    private TreeModel treeModel;
    private TreeClusteringVirusesPrior clusterPrior;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeModel.class), new ElementRule(TreeClusteringVirusesPrior.class)};

        @Override
        public String getParserName() {
            return DriverCountStatistic.DRIVERCOUNT_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            TreeClusteringVirusesPrior treeClusteringVirusesPrior = (TreeClusteringVirusesPrior)xMLObject.getChild(TreeClusteringVirusesPrior.class);
            return new DriverCountStatistic(treeModel, treeClusteringVirusesPrior);
        }

        @Override
        public String getParserDescription() {
            return ".";
        }

        @Override
        public Class getReturnType() {
            return DriverCountStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public DriverCountStatistic(TreeModel treeModel, TreeClusteringVirusesPrior treeClusteringVirusesPrior) {
        this.treeModel = treeModel;
        this.clusterPrior = treeClusteringVirusesPrior;
    }

    @Override
    public int getDimension() {
        int[] nArray = this.clusterPrior.getCausalCount();
        int n = nArray.length * 2;
        return n;
    }

    @Override
    public double getStatisticValue(int n) {
        int[] nArray = this.clusterPrior.getCausalCount();
        int[] nArray2 = this.clusterPrior.getNonCausalCount();
        int n2 = n / 2;
        double d = -1.0;
        d = n % 2 == 0 ? (double)nArray[n2] : (double)nArray2[n2];
        return d;
    }

    @Override
    public String getDimensionName(int n) {
        String string = "";
        string = n % 2 == 0 ? string + "C" : string + "N";
        string = string + "" + (n / 2 + 1);
        return string;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }
}

