/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.TaxonList;
import dr.util.FrequencySet;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class CladeSet
extends FrequencySet<BitSet> {
    private TaxonList taxonList = null;
    private final Map<BitSet, Double> totalNodeHeight = new HashMap<BitSet, Double>();
    private int totalTrees = 0;

    public CladeSet() {
    }

    public CladeSet(Tree tree) {
        this(tree, tree);
    }

    public CladeSet(Tree tree, TaxonList taxonList) {
        this.taxonList = taxonList;
        this.add(tree);
    }

    public int getCladeCount() {
        return this.size();
    }

    public String getClade(int n) {
        BitSet bitSet = (BitSet)this.get(n);
        StringBuffer stringBuffer = new StringBuffer("{");
        boolean bl = true;
        for (String string : this.getTaxaSet(bitSet)) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append(string);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private SortedSet<String> getTaxaSet(BitSet bitSet) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < bitSet.length(); ++i) {
            if (!bitSet.get(i)) continue;
            treeSet.add(this.taxonList.getTaxonId(i));
        }
        return treeSet;
    }

    int getCladeFrequency(int n) {
        return this.getFrequency(n);
    }

    @Override
    public void add(Tree tree) {
        if (this.taxonList == null) {
            this.taxonList = tree;
        }
        ++this.totalTrees;
        this.addClades(tree, tree.getRoot(), null);
    }

    private void addClades(Tree tree, NodeRef nodeRef, BitSet bitSet) {
        if (tree.isExternal(nodeRef)) {
            if (this.taxonList != null) {
                int n = this.taxonList.getTaxonIndex(tree.getNodeTaxon(nodeRef).getId());
                bitSet.set(n);
            } else {
                bitSet.set(nodeRef.getNumber());
            }
        } else {
            BitSet bitSet2 = new BitSet();
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree.getChild(nodeRef, i);
                this.addClades(tree, nodeRef2, bitSet2);
            }
            this.add(bitSet2, 1);
            this.addNodeHeight(bitSet2, tree.getNodeHeight(nodeRef));
            if (bitSet != null) {
                bitSet.or(bitSet2);
            }
        }
    }

    public double getMeanNodeHeight(int n) {
        BitSet bitSet = (BitSet)this.get(n);
        return this.getTotalNodeHeight(bitSet) / (double)this.getFrequency(n);
    }

    private double getTotalNodeHeight(BitSet bitSet) {
        Double d = this.totalNodeHeight.get(bitSet);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    private void addNodeHeight(BitSet bitSet, double d) {
        this.totalNodeHeight.put(bitSet, this.getTotalNodeHeight(bitSet) + d);
    }

    private BitSet annotate(MutableTree mutableTree, NodeRef nodeRef, String string) {
        BitSet bitSet = null;
        if (mutableTree.isExternal(nodeRef)) {
            int n = this.taxonList != null ? this.taxonList.getTaxonIndex(mutableTree.getNodeTaxon(nodeRef).getId()) : nodeRef.getNumber();
            bitSet = new BitSet(mutableTree.getExternalNodeCount());
            bitSet.set(n);
        } else {
            int n;
            for (n = 0; n < mutableTree.getChildCount(nodeRef); ++n) {
                NodeRef nodeRef2 = mutableTree.getChild(nodeRef, n);
                BitSet bitSet2 = this.annotate(mutableTree, nodeRef2, string);
                if (n == 0) {
                    bitSet = bitSet2;
                    continue;
                }
                bitSet.or(bitSet2);
            }
            n = this.getFrequency(bitSet);
            if (n >= 0) {
                mutableTree.setNodeAttribute(nodeRef, string, (double)n / (double)this.totalTrees);
            }
        }
        return bitSet;
    }

    public double annotate(MutableTree mutableTree, String string) {
        this.annotate(mutableTree, mutableTree.getRoot(), string);
        double d = 0.0;
        for (int i = 0; i < mutableTree.getInternalNodeCount(); ++i) {
            double d2 = (Double)mutableTree.getNodeAttribute(mutableTree.getInternalNode(i), string);
            d += Math.log(d2);
        }
        return d;
    }

    public boolean hasClade(int n, Tree tree) {
        BitSet bitSet = (BitSet)this.get(n);
        NodeRef[] nodeRefArray = new NodeRef[1];
        this.findClade(bitSet, tree, tree.getRoot(), nodeRefArray);
        return nodeRefArray[0] != null;
    }

    private int findClade(BitSet bitSet, Tree tree, NodeRef nodeRef, NodeRef[] nodeRefArray) {
        if (tree.isExternal(nodeRef)) {
            int n;
            if (this.taxonList != null ? bitSet.get(n = this.taxonList.getTaxonIndex(tree.getNodeTaxon(nodeRef).getId())) : bitSet.get(nodeRef.getNumber())) {
                return 1;
            }
            return -1;
        }
        int n = 0;
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            int n2 = this.findClade(bitSet, tree, nodeRef2, nodeRefArray);
            if (n2 != -1 && n != -1) {
                n += n2;
                continue;
            }
            n = -1;
        }
        if (n == bitSet.cardinality()) {
            nodeRefArray[0] = nodeRef;
        }
        return n;
    }
}

