/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.basta;

import dr.evolution.alignment.PatternList;
import dr.evolution.coalescent.IntervalType;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evolution.util.Units;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.branchratemodel.DefaultBranchRateModel;
import dr.evomodel.coalescent.AbstractCoalescentLikelihood;
import dr.evomodel.coalescent.TreeIntervals;
import dr.evomodel.substmodel.GeneralSubstitutionModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.ComparableDouble;
import dr.util.HeapSort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OldStructuredCoalescentLikelihood
extends AbstractCoalescentLikelihood
implements Citable {
    private static final boolean DEBUG = false;
    private static final boolean MATRIX_DEBUG = false;
    private static final boolean UPDATE_DEBUG = false;
    private static final boolean ASSOC_MULTIPLICATION = true;
    public static Citation CITATION = new Citation(new Author[]{new Author("Nicola", "De Maio"), new Author("Chieh-Hsi", "Wu"), new Author("Kathleen", "O'Reilly"), new Author("Daniel", "Wilson")}, "New routes to phylogeography: a Bayesian structured coalescent approximation", 2015, "PLOS Genetics", 11, "e1005421", "10.1371/journal.pgen.1005421");
    private TreeModel treeModel;
    private BranchRateModel branchRateModel;
    private Parameter popSizes;
    private PatternList patternList;
    private double[] startExpected;
    private double[] endExpected;
    private ProbDist[] nodeProbDist;
    private ArrayList<ComparableDouble> times;
    private ArrayList<Integer> children;
    private ArrayList<NodeRef> nodes;
    private int[] indices;
    private ArrayList<ComparableDouble> storedTimes;
    private ArrayList<Integer> storedChildren;
    private ArrayList<NodeRef> storedNodes;
    private int[] storedIndices;
    private ArrayList<ProbDist> activeLineageList;
    private ArrayList<ProbDist> tempLineageList;
    private GeneralSubstitutionModel generalSubstitutionModel;
    private int demes;
    private int subIntervals;
    private int maxCoalescentIntervals;
    private int currentCoalescentInterval;
    private double[][] migrationMatrices;
    private int finalCoalescentInterval;
    private double[][] storedMigrationMatrices;
    private boolean matricesKnown;
    private boolean rateChanged;
    private boolean treeModelUpdateFired;

    public OldStructuredCoalescentLikelihood(Tree tree, BranchRateModel branchRateModel, Parameter parameter, PatternList patternList, GeneralSubstitutionModel generalSubstitutionModel, int n, TaxonList taxonList, List<TaxonList> list) throws TreeUtils.MissingTaxonException {
        super("structuredCoalescent", new TreeIntervals(tree, taxonList, list));
        this.treeModel = (TreeModel)tree;
        this.patternList = patternList;
        this.popSizes = parameter;
        this.addVariable(this.popSizes);
        this.branchRateModel = branchRateModel != null ? branchRateModel : new DefaultBranchRateModel();
        this.addModel(this.branchRateModel);
        this.generalSubstitutionModel = generalSubstitutionModel;
        this.addModel(this.generalSubstitutionModel);
        this.demes = generalSubstitutionModel.getDataType().getStateCount();
        this.startExpected = new double[this.demes];
        this.endExpected = new double[this.demes];
        this.subIntervals = n;
        this.activeLineageList = new ArrayList();
        this.tempLineageList = new ArrayList();
        this.nodeProbDist = new ProbDist[this.treeModel.getNodeCount()];
        this.maxCoalescentIntervals = this.treeModel.getTaxonCount() * 2 - 2;
        this.currentCoalescentInterval = 0;
        this.migrationMatrices = new double[this.maxCoalescentIntervals][this.demes * this.demes];
        this.storedMigrationMatrices = new double[this.maxCoalescentIntervals][this.demes * this.demes];
        this.times = new ArrayList();
        this.children = new ArrayList();
        this.nodes = new ArrayList();
        this.storedTimes = new ArrayList();
        this.storedChildren = new ArrayList();
        this.storedNodes = new ArrayList();
        this.treeModelUpdateFired = false;
        this.rateChanged = false;
    }

    @Override
    public double calculateLogLikelihood() {
        this.logLikelihood = this.traverseTree(this.treeModel, this.treeModel.getRoot(), this.patternList);
        return this.logLikelihood;
    }

    private double traverseTree(Tree tree, NodeRef nodeRef, PatternList patternList) {
        double d = 1.0E-9;
        if (this.treeModelUpdateFired && !this.rateChanged) {
            this.updateTransitionProbabilities();
            this.treeModelUpdateFired = false;
        } else {
            this.times.clear();
            this.children.clear();
            this.nodes.clear();
            this.collectAllTimes(tree, nodeRef, this.nodes, this.times, this.children);
            this.indices = new int[this.times.size()];
            HeapSort.sort(this.times, this.indices);
        }
        double d2 = 0.0;
        double d3 = this.times.get(this.indices[0]).doubleValue();
        int n = 0;
        int n2 = 0;
        while (n < this.times.size()) {
            ProbDist probDist;
            NodeRef nodeRef2;
            double d4;
            int n3 = 0;
            int n4 = 0;
            double d5 = d4 = this.times.get(this.indices[n]).doubleValue();
            double d6 = d4 - d3;
            while (Math.abs(d5 - d4) < d) {
                int n5 = this.children.get(this.indices[n]);
                if (n5 == 0) {
                    ++n4;
                } else {
                    n3 += n5 - 1;
                }
                if (++n == this.times.size()) break;
                d5 = this.times.get(this.indices[n]).doubleValue();
            }
            if (n4 > 0) {
                if (d6 > d) {
                    this.incrementActiveLineages(d4 - d3);
                    while (Math.abs(this.treeModel.getNodeHeight(this.nodes.get(this.indices[n2])) - d4) < d) {
                        NodeRef nodeRef3 = this.nodes.get(this.indices[n2]);
                        if (this.treeModel.isExternal(nodeRef3)) {
                            ProbDist probDist2 = new ProbDist(this.demes, 0.0, nodeRef3);
                            probDist2.setIntervalType(IntervalType.SAMPLE);
                            probDist2.setStartLineageProb(patternList.getPattern(0)[patternList.getTaxonIndex(this.treeModel.getNodeTaxon(probDist2.node).getId())], 1.0);
                            probDist2.computeEndLineageDensities(0.0, null);
                            this.tempLineageList.add(probDist2);
                            this.nodeProbDist[nodeRef3.getNumber()] = probDist2;
                        } else {
                            if (this.treeModel.getChildCount(nodeRef3) > 2) {
                                throw new RuntimeException("Structured coalescent currently only allows strictly bifurcating trees.");
                            }
                            NodeRef nodeRef4 = this.treeModel.getChild(nodeRef3, 0);
                            nodeRef2 = this.treeModel.getChild(nodeRef3, 1);
                            probDist = new ProbDist(this.demes, d6, nodeRef3, nodeRef4, nodeRef2);
                            probDist.setIntervalType(IntervalType.COALESCENT);
                            this.tempLineageList.add(probDist);
                        }
                        if (++n2 < this.indices.length) continue;
                        n2 = 0;
                        break;
                    }
                } else {
                    while (Math.abs(this.treeModel.getNodeHeight(this.nodes.get(this.indices[n2])) - d3) < d) {
                        NodeRef nodeRef4 = this.nodes.get(this.indices[n2]);
                        if (!this.treeModel.isExternal(nodeRef4)) {
                            throw new RuntimeException("First interval cannot be a coalescent event.");
                        }
                        ProbDist probDist3 = new ProbDist(this.demes, 0.0, nodeRef4);
                        probDist3.setIntervalType(IntervalType.SAMPLE);
                        probDist3.setStartLineageProb(patternList.getPattern(0)[patternList.getTaxonIndex(this.treeModel.getNodeTaxon(probDist3.node).getId())], 1.0);
                        probDist3.computeEndLineageDensities(0.0, null);
                        this.tempLineageList.add(probDist3);
                        this.nodeProbDist[nodeRef4.getNumber()] = probDist3;
                        if (++n2 < this.indices.length) continue;
                        n2 = 0;
                        break;
                    }
                }
                d3 = d4;
            }
            if (n3 > 0) {
                this.incrementActiveLineages(d4 - d3);
                while (Math.abs(this.treeModel.getNodeHeight(this.nodes.get(this.indices[n2])) - d4) < d) {
                    NodeRef nodeRef5 = this.nodes.get(this.indices[n2]);
                    if (this.treeModel.isExternal(nodeRef5)) {
                        ProbDist probDist4 = new ProbDist(this.demes, d6, nodeRef5);
                        probDist4.setIntervalType(IntervalType.SAMPLE);
                        probDist4.setStartLineageProb(patternList.getPattern(0)[patternList.getTaxonIndex(this.treeModel.getNodeTaxon(probDist4.node).getId())], 1.0);
                        probDist4.computeEndLineageDensities(0.0, null);
                        this.tempLineageList.add(probDist4);
                        this.nodeProbDist[nodeRef5.getNumber()] = probDist4;
                    } else {
                        if (this.treeModel.getChildCount(nodeRef5) > 2) {
                            throw new RuntimeException("Structured coalescent currently only allows strictly bifurcating trees.");
                        }
                        NodeRef nodeRef6 = this.treeModel.getChild(nodeRef5, 0);
                        nodeRef2 = this.treeModel.getChild(nodeRef5, 1);
                        probDist = this.nodeProbDist[nodeRef6.getNumber()];
                        ProbDist probDist5 = this.nodeProbDist[nodeRef2.getNumber()];
                        this.tempLineageList.remove(probDist);
                        this.tempLineageList.remove(probDist5);
                        ProbDist probDist6 = new ProbDist(this.demes, d6, nodeRef5, nodeRef6, nodeRef2);
                        probDist6.setIntervalType(IntervalType.COALESCENT);
                        d2 += probDist6.computeCoalescedLineage(probDist, probDist5);
                        if (!this.treeModel.isRoot(nodeRef5)) {
                            this.tempLineageList.add(probDist6);
                            this.nodeProbDist[nodeRef5.getNumber()] = probDist6;
                        }
                    }
                    if (++n2 < this.indices.length) continue;
                    break;
                }
                d3 = d4;
            }
            if (d4 != 0.0) {
                this.computeExpectedLineageCounts();
            }
            if (d4 != 0.0) {
                d2 += this.computeLogLikelihood(d6);
            }
            this.activeLineageList.clear();
            for (ProbDist probDist7 : this.tempLineageList) {
                this.activeLineageList.add(probDist7);
            }
        }
        this.finalCoalescentInterval = this.currentCoalescentInterval;
        this.currentCoalescentInterval = 0;
        this.matricesKnown = true;
        this.rateChanged = false;
        return d2;
    }

    private double computeLogLikelihood(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.demes; ++i) {
            double d4 = 0.0;
            double d5 = 0.0;
            for (ProbDist probDist : this.activeLineageList) {
                d4 += probDist.getStartLineageProb(i) * probDist.getStartLineageProb(i);
                d5 += probDist.getEndLineageProb(i) * probDist.getEndLineageProb(i);
            }
            d2 += 1.0 / this.popSizes.getParameterValue(i) * (this.startExpected[i] * this.startExpected[i] - d4);
            d3 += 1.0 / this.popSizes.getParameterValue(i) * (this.endExpected[i] * this.endExpected[i] - d5);
        }
        return (d2 *= -d / 4.0) + (d3 *= -d / 4.0);
    }

    private void computeExpectedLineageCounts() {
        for (int i = 0; i < this.demes; ++i) {
            this.startExpected[i] = 0.0;
            this.endExpected[i] = 0.0;
            for (ProbDist probDist : this.activeLineageList) {
                int n = i;
                this.startExpected[n] = this.startExpected[n] + probDist.getStartLineageProb(i);
                int n2 = i;
                this.endExpected[n2] = this.endExpected[n2] + probDist.getEndLineageProb(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementActiveLineages(double d) {
        double d2;
        BranchRateModel branchRateModel = this.branchRateModel;
        synchronized (branchRateModel) {
            d2 = this.branchRateModel.getBranchRate(this.treeModel, this.treeModel.getRoot());
        }
        if (!this.matricesKnown) {
            this.generalSubstitutionModel.getTransitionProbabilities(d2 * d, this.migrationMatrices[this.currentCoalescentInterval]);
        }
        for (ProbDist probDist : this.activeLineageList) {
            probDist.incrementIntervalLength(d, this.migrationMatrices[this.currentCoalescentInterval]);
        }
        ++this.currentCoalescentInterval;
    }

    private void collectAllTimes(Tree tree, NodeRef nodeRef, ArrayList<NodeRef> arrayList, ArrayList<ComparableDouble> arrayList2, ArrayList<Integer> arrayList3) {
        arrayList2.add(new ComparableDouble(tree.getNodeHeight(nodeRef)));
        arrayList.add(nodeRef);
        arrayList3.add(tree.getChildCount(nodeRef));
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            this.collectAllTimes(tree, nodeRef2, arrayList, arrayList2, arrayList3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTransitionProbabilities() {
        double d;
        double[] dArray = new double[this.times.size() - 1];
        for (int i = 1; i < this.times.size(); ++i) {
            dArray[i - 1] = this.times.get(this.indices[i]).doubleValue() - this.times.get(this.indices[i - 1]).doubleValue();
        }
        this.storedTimes.clear();
        this.storedNodes.clear();
        this.storedChildren.clear();
        this.collectAllTimes(this.treeModel, this.treeModel.getRoot(), this.storedNodes, this.storedTimes, this.storedChildren);
        this.storedIndices = new int[this.storedTimes.size()];
        HeapSort.sort(this.storedTimes, this.storedIndices);
        double[] dArray2 = new double[this.storedTimes.size() - 1];
        for (int i = 1; i < this.storedTimes.size(); ++i) {
            dArray2[i - 1] = this.storedTimes.get(this.storedIndices[i]).doubleValue() - this.storedTimes.get(this.storedIndices[i - 1]).doubleValue();
        }
        BranchRateModel branchRateModel = this.branchRateModel;
        synchronized (branchRateModel) {
            d = this.branchRateModel.getBranchRate(this.treeModel, this.treeModel.getRoot());
        }
        int n = 0;
        if (dArray.length == dArray2.length) {
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i] != dArray2[i] && dArray2[i] != 0.0) {
                    this.generalSubstitutionModel.getTransitionProbabilities(d * dArray2[i], this.migrationMatrices[n]);
                    ++n;
                    continue;
                }
                if (dArray2[i] == 0.0) continue;
                ++n;
            }
        } else {
            throw new RuntimeException("Number of coalescent intervals has increased?");
        }
        this.times = this.storedTimes;
        this.nodes = this.storedNodes;
        this.children = this.storedChildren;
        this.indices = this.storedIndices;
        this.matricesKnown = true;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.treeModel) {
            this.likelihoodKnown = false;
            this.matricesKnown = false;
            this.treeModelUpdateFired = true;
        } else if (model == this.branchRateModel) {
            this.likelihoodKnown = false;
            this.matricesKnown = false;
            this.rateChanged = true;
        } else if (model == this.generalSubstitutionModel) {
            this.likelihoodKnown = false;
            this.matricesKnown = false;
            this.rateChanged = true;
        } else {
            throw new RuntimeException("Unknown handleModelChangedEvent source, exiting.");
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.likelihoodKnown = false;
        this.matricesKnown = true;
    }

    @Override
    protected void storeState() {
        for (int i = 0; i < this.finalCoalescentInterval; ++i) {
            System.arraycopy(this.migrationMatrices[i], 0, this.storedMigrationMatrices[i], 0, this.demes * this.demes);
        }
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        for (int i = 0; i < this.finalCoalescentInterval; ++i) {
            double[] dArray = this.migrationMatrices[i];
            this.migrationMatrices[i] = this.storedMigrationMatrices[i];
            this.storedMigrationMatrices[i] = dArray;
        }
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
        this.matricesKnown = false;
    }

    @Override
    public final void setUnits(Units.Type type) {
        this.treeModel.setUnits(type);
    }

    @Override
    public final Units.Type getUnits() {
        return this.treeModel.getUnits();
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Bayesian structured coalescent approximation";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }

    private class ProbDist {
        private double[] startLineageProbs;
        private double[] endLineageProbs;
        private double intervalLength;
        private NodeRef node;
        private boolean incremented = false;
        private IntervalType intervalType;
        private NodeRef leftChild = null;
        private NodeRef rightChild = null;

        public ProbDist(int n, double d, NodeRef nodeRef) {
            this.startLineageProbs = new double[n];
            this.endLineageProbs = new double[n];
            this.intervalLength = d;
            this.node = nodeRef;
        }

        public ProbDist(int n, double d, NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
            this.startLineageProbs = new double[n];
            this.endLineageProbs = new double[n];
            this.intervalLength = d;
            this.node = nodeRef;
            this.leftChild = nodeRef2;
            this.rightChild = nodeRef3;
        }

        public double computeCoalescedLineage(ProbDist probDist, ProbDist probDist2) {
            int n;
            double d = 0.0;
            double[] dArray = new double[OldStructuredCoalescentLikelihood.this.demes];
            for (n = 0; n < OldStructuredCoalescentLikelihood.this.demes; ++n) {
                dArray[n] = probDist.getEndLineageProb(n) * probDist2.getEndLineageProb(n) / OldStructuredCoalescentLikelihood.this.popSizes.getParameterValue(n);
                d += dArray[n];
            }
            for (n = 0; n < OldStructuredCoalescentLikelihood.this.demes; ++n) {
                this.setStartLineageProb(n, dArray[n] / d);
            }
            this.intervalLength = 0.0;
            return Math.log(d);
        }

        public void computeEndLineageDensities(double d, double[] dArray) {
            if (d == 0.0) {
                for (int i = 0; i < OldStructuredCoalescentLikelihood.this.demes; ++i) {
                    this.setEndLineageProb(i, this.getStartLineageProb(i));
                }
            } else {
                for (int i = 0; i < OldStructuredCoalescentLikelihood.this.demes; ++i) {
                    double d2 = 0.0;
                    for (int j = 0; j < OldStructuredCoalescentLikelihood.this.demes; ++j) {
                        d2 += this.startLineageProbs[j] * dArray[j * OldStructuredCoalescentLikelihood.this.demes + i];
                    }
                    this.setEndLineageProb(i, d2);
                }
            }
        }

        public void incrementIntervalLength(double d, double[] dArray) {
            this.intervalLength += d;
            if (this.incremented) {
                for (int i = 0; i < OldStructuredCoalescentLikelihood.this.demes; ++i) {
                    this.startLineageProbs[i] = this.endLineageProbs[i];
                }
                this.computeEndLineageDensities(d, dArray);
            } else {
                this.computeEndLineageDensities(this.intervalLength, dArray);
            }
            this.incremented = true;
        }

        public IntervalType getIntervalType() {
            return this.intervalType;
        }

        public void setIntervalType(IntervalType intervalType) {
            this.intervalType = intervalType;
        }

        public NodeRef getLeftChild() {
            return this.leftChild;
        }

        public NodeRef getRightChild() {
            return this.rightChild;
        }

        public double getStartLineageProb(int n) {
            return this.startLineageProbs[n];
        }

        public double getEndLineageProb(int n) {
            return this.endLineageProbs[n];
        }

        public void setStartLineageProb(int n, double d) {
            this.startLineageProbs[n] = d;
        }

        private void setEndLineageProb(int n, double d) {
            this.endLineageProbs[n] = d;
        }

        public String toString() {
            int n;
            String string = "Node " + this.node + " ; length = " + this.intervalLength + " S(";
            for (n = 0; n < this.startLineageProbs.length; ++n) {
                string = string + this.startLineageProbs[n] + " ";
            }
            string = string + ") E(";
            for (n = 0; n < this.endLineageProbs.length; ++n) {
                string = string + this.endLineageProbs[n] + " ";
            }
            string = string + ")";
            return string;
        }
    }
}

