/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ViewTransform {
    double scaleX;
    double scaleY;
    int width;
    int height;
    Point2D topLeft;
    Point2D bottomRight;
    AffineTransform transform;

    public ViewTransform(Rectangle2D rectangle2D, int n, int n2) {
        this.set(rectangle2D, n, n2);
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public Rectangle2D getViewport() {
        return new Rectangle2D.Double(this.topLeft.getX(), this.topLeft.getY(), this.bottomRight.getX() - this.topLeft.getX(), this.bottomRight.getY() - this.topLeft.getY());
    }

    public void set(Rectangle2D rectangle2D, int n, int n2) {
        this.topLeft = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY());
        this.bottomRight = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMaxY());
        this.width = n;
        this.height = n2;
        this.computeScalesAndTransform();
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.topLeft = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY());
        this.bottomRight = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMaxY());
        this.computeScalesAndTransform();
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.computeScalesAndTransform();
    }

    private void computeScalesAndTransform() {
        this.scaleX = (double)this.width / (this.bottomRight.getX() - this.topLeft.getX());
        this.scaleY = (double)this.height / (this.bottomRight.getY() - this.topLeft.getY());
        this.transform = this.computeFullTransform();
    }

    private AffineTransform getTranslate() {
        return AffineTransform.getTranslateInstance(-this.topLeft.getX(), -this.bottomRight.getY());
    }

    private AffineTransform getScale() {
        return AffineTransform.getScaleInstance(this.scaleX, -this.scaleY);
    }

    private AffineTransform computeFullTransform() {
        AffineTransform affineTransform = this.getScale();
        affineTransform.concatenate(this.getTranslate());
        return affineTransform;
    }
}

