/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.markovjumps;

import java.util.Arrays;

public class MarkovJumpsCore {
    private final int stateCount;
    private final int stateCount2;
    private final double[] auxInt;
    private final double[] tmp1;
    private final double[] tmp2;
    private final double[] expEvalScalar;

    public MarkovJumpsCore(int n) {
        this.stateCount = n;
        this.stateCount2 = n * n;
        this.auxInt = new double[this.stateCount2];
        this.tmp1 = new double[this.stateCount2];
        this.tmp2 = new double[this.stateCount2];
        this.expEvalScalar = new double[n];
    }

    private void populateAuxInt(double[] dArray, double d, double[] dArray2) {
        int n;
        for (n = 0; n < this.stateCount; ++n) {
            this.expEvalScalar[n] = Math.exp(dArray[n] * d);
        }
        n = 0;
        for (int i = 0; i < this.stateCount; ++i) {
            for (int j = 0; j < this.stateCount; ++j) {
                dArray2[n] = Math.abs(dArray[i] - dArray[j]) < 1.0E-7 ? this.expEvalScalar[i] * d : (this.expEvalScalar[i] - this.expEvalScalar[j]) / (dArray[i] - dArray[j]);
                ++n;
            }
        }
    }

    public void computeCondStatMarkovJumps(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, double[] dArray5, double[] dArray6) {
        this.computeJointStatMarkovJumps(dArray, dArray2, dArray3, dArray4, d, dArray6);
        for (int i = 0; i < this.stateCount2; ++i) {
            int n = i;
            dArray6[n] = dArray6[n] / dArray5[i];
        }
    }

    public void computeCondStatMarkovJumpsPrecompute(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, double[] dArray5, double[] dArray6) {
        this.computeJointStatMarkovJumpsPrecompute(dArray, dArray2, dArray3, dArray4, d, dArray6);
        for (int i = 0; i < this.stateCount2; ++i) {
            int n = i;
            dArray6[n] = dArray6[n] / dArray5[i];
        }
    }

    public void computeJointStatMarkovJumps(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, double[] dArray5) {
        this.populateAuxInt(dArray3, d, this.auxInt);
        MarkovJumpsCore.matrixMultiply(dArray4, dArray, this.stateCount, this.tmp1);
        MarkovJumpsCore.matrixMultiply(dArray2, this.tmp1, this.stateCount, this.tmp2);
        for (int i = 0; i < this.stateCount2; ++i) {
            int n = i;
            this.tmp2[n] = this.tmp2[n] * this.auxInt[i];
        }
        MarkovJumpsCore.matrixMultiply(this.tmp2, dArray2, this.stateCount, this.tmp1);
        MarkovJumpsCore.matrixMultiply(dArray, this.tmp1, this.stateCount, dArray5);
    }

    public void computeJointStatMarkovJumpsPrecompute(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, double[] dArray5) {
        this.populateAuxInt(dArray3, d, this.auxInt);
        for (int i = 0; i < this.stateCount2; ++i) {
            this.tmp2[i] = this.auxInt[i] * dArray4[i];
        }
        MarkovJumpsCore.matrixMultiply(this.tmp2, dArray2, this.stateCount, this.tmp1);
        MarkovJumpsCore.matrixMultiply(dArray, this.tmp1, this.stateCount, dArray5);
    }

    public static void matrixMultiply(double[] dArray, double[] dArray2, int n, double[] dArray3) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray3[n2] = 0.0;
                for (int k = 0; k < n; ++k) {
                    int n3 = n2;
                    dArray3[n3] = dArray3[n3] + dArray[i * n + k] * dArray2[k * n + j];
                }
                ++n2;
            }
        }
    }

    public static void fillRegistrationMatrix(double[] dArray, int n) {
        Arrays.fill(dArray, 1.0);
        for (int i = 0; i < n; ++i) {
            dArray[i * n + i] = 0.0;
        }
    }

    public static void fillRegistrationMatrix(double[] dArray, int n, int n2, int n3) {
        MarkovJumpsCore.fillRegistrationMatrix(dArray, n, n2, n3, 1.0);
    }

    public static void fillRegistrationMatrix(double[] dArray, int n, int n2, int n3, double d) {
        Arrays.fill(dArray, 0.0);
        dArray[n * n3 + n2] = d;
    }

    public static void swapRows(double[] dArray, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            double d = dArray[n * n3 + i];
            dArray[n * n3 + i] = dArray[n2 * n3 + i];
            dArray[n2 * n3 + i] = d;
        }
    }

    public static void swapCols(double[] dArray, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            double d = dArray[i * n3 + n];
            dArray[i * n3 + n] = dArray[i * n3 + n2];
            dArray[i * n3 + n2] = d;
        }
    }

    public static void makeComparableToRPackage(double[] dArray) {
        if (dArray.length == 16) {
            MarkovJumpsCore.swapRows(dArray, 1, 2, 4);
            MarkovJumpsCore.swapCols(dArray, 1, 2, 4);
        } else if (dArray.length == 4) {
            MarkovJumpsCore.swapCols(dArray, 1, 2, 1);
        } else {
            throw new RuntimeException("Function constructed for nucleotides");
        }
    }
}

