/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.GeneralBoundsProvider;
import dr.inference.operators.hmc.HamiltonianMonteCarloOperator;
import dr.math.MathUtils;
import dr.math.matrixAlgebra.EJMLUtils;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.SymmetricMatrix;
import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.interfaces.decomposition.EigenDecomposition;
import org.ejml.ops.CommonOps;

public interface BoundedSpace
extends GeneralBoundsProvider {
    public boolean isWithinBounds(double[] var1);

    public IntersectionDistances distancesToBoundary(double[] var1, double[] var2, boolean var3) throws HamiltonianMonteCarloOperator.NumericInstabilityException;

    public double[] getNormalVectorAtBoundary(double[] var1);

    default public double forwardDistanceToBoundary(double[] dArray, double[] dArray2, boolean bl) throws HamiltonianMonteCarloOperator.NumericInstabilityException {
        return this.distancesToBoundary((double[])dArray, (double[])dArray2, (boolean)bl).forwardDistance;
    }

    public static class IntersectionDistances {
        public final double forwardDistance;
        public final double backwardDistance;
        public final double totalDistance;

        public IntersectionDistances(double d, double d2) {
            this.forwardDistance = d;
            this.backwardDistance = d2;
            this.totalDistance = d + d2;
        }
    }

    public static class Correlation
    implements BoundedSpace {
        private static final boolean DEBUG = false;
        private static final boolean CHECK_WITHIN_BOUNDS = false;
        private static final double TOL = 0.0;
        private static final double BOUNDARY_TOL = 1.0E-9;
        private final int dim;
        private final DenseMatrix64F C;
        private final DenseMatrix64F V;
        private final DenseMatrix64F Cinv;
        private final DenseMatrix64F CinvV;

        public Correlation(int n) {
            this.dim = n;
            this.V = new DenseMatrix64F(n, n);
            this.C = new DenseMatrix64F(n, n);
            for (int i = 0; i < n; ++i) {
                this.C.set(i, i, 1.0);
            }
            this.Cinv = new DenseMatrix64F(n, n);
            this.CinvV = new DenseMatrix64F(n, n);
        }

        @Override
        public boolean isWithinBounds(double[] dArray) {
            CholeskyDecomposition<DenseMatrix64F> choleskyDecomposition;
            int n;
            int n2;
            int n3;
            DenseMatrix64F denseMatrix64F;
            double[] dArray2 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            if (dArray2.length == this.dim * this.dim) {
                denseMatrix64F = DenseMatrix64F.wrap(this.dim, this.dim, dArray2);
                for (n3 = 0; n3 < this.dim; ++n3) {
                    if (denseMatrix64F.get(n3, n3) == 1.0) continue;
                    return false;
                }
            } else if (dArray2.length == this.dim * (this.dim - 1) / 2) {
                n3 = 0;
                denseMatrix64F = new DenseMatrix64F(this.dim, this.dim);
                for (n2 = 0; n2 < this.dim; ++n2) {
                    denseMatrix64F.set(n2, n2, 1.0);
                    for (n = n2 + 1; n < this.dim; ++n) {
                        denseMatrix64F.set(n2, n, dArray2[n3]);
                        denseMatrix64F.set(n, n2, dArray2[n3]);
                        ++n3;
                    }
                }
            } else {
                throw new RuntimeException("incompatible dimensions");
            }
            if ((n2 = (choleskyDecomposition = DecompositionFactory.chol(this.dim, true)).decompose(denseMatrix64F)) == 0) {
                return false;
            }
            for (n = 0; n < this.dim; ++n) {
                if (!(denseMatrix64F.get(n, n) <= 0.0)) continue;
                return false;
            }
            return true;
        }

        private double[] robustTrajectoryEigenValues(double[] dArray, double[] dArray2) {
            double d = MathUtils.nextDouble();
            double[] dArray3 = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray3[i] = dArray[i] + d * dArray2[i];
            }
            double[] dArray4 = this.trajectoryEigenvalues(dArray3, dArray2);
            int n = 0;
            while (n < dArray4.length) {
                int n2 = n++;
                dArray4[n2] = dArray4[n2] - d;
            }
            return dArray4;
        }

        private double[] trajectoryEigenvalues(double[] dArray, double[] dArray2) {
            double[] dArray3 = new double[dArray.length];
            System.arraycopy(dArray2, 0, dArray3, 0, dArray3.length);
            int n = 0;
            for (int i = 0; i < this.dim; ++i) {
                for (int j = i + 1; j < this.dim; ++j) {
                    this.C.set(i, j, dArray[n]);
                    this.C.set(j, i, dArray[n]);
                    this.V.set(i, j, dArray2[n]);
                    this.V.set(j, i, dArray2[n]);
                    ++n;
                }
            }
            CommonOps.invert(this.C, this.Cinv);
            CommonOps.mult(this.Cinv, this.V, this.CinvV);
            new DecompositionFactory();
            EigenDecomposition<DenseMatrix64F> eigenDecomposition = DecompositionFactory.eig(this.dim, false, false);
            if (!eigenDecomposition.decompose(this.CinvV)) {
                throw new RuntimeException("Eigen decomposition failed.");
            }
            double[] dArray4 = new double[this.dim];
            int n2 = 0;
            for (int i = 0; i < this.dim; ++i) {
                Complex64F complex64F = eigenDecomposition.getEigenvalue(i);
                if (!complex64F.isReal()) continue;
                dArray4[n2] = complex64F.real;
                ++n2;
            }
            double[] dArray5 = new double[n2];
            System.arraycopy(dArray4, 0, dArray5, 0, n2);
            for (int i = 0; i < dArray5.length; ++i) {
                dArray5[i] = 1.0 / dArray5[i];
            }
            return dArray5;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public IntersectionDistances distancesToBoundary(double[] dArray, double[] dArray2, boolean bl) throws HamiltonianMonteCarloOperator.NumericInstabilityException {
            double[] dArray3 = this.robustTrajectoryEigenValues(dArray, dArray2);
            double d = Double.NEGATIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            double d3 = Double.POSITIVE_INFINITY;
            double d4 = Double.POSITIVE_INFINITY;
            for (int i = 0; i < dArray3.length; ++i) {
                double d5 = dArray3[i];
                if (d5 < -0.0 && d5 > d) {
                    d2 = d;
                    d = d5;
                    continue;
                }
                if (d5 < -0.0 && d5 > d2) {
                    d2 = d5;
                    continue;
                }
                if (d5 >= 0.0 & d5 < d3) {
                    d4 = d3;
                    d3 = d5;
                    continue;
                }
                if (!(d5 >= 0.0) || !(d5 < d4)) continue;
                d4 = d5;
            }
            if (bl) {
                if (Math.abs(d) < d3) {
                    if (!(Math.abs(d) < 1.0E-9)) throw new RuntimeException("isAtBoundary = true but does not appear to be near boundary");
                    d = d2;
                } else {
                    if (!(d3 < 1.0E-9)) throw new RuntimeException("isAtBoundary = true but does not appear to be near boundary");
                    d3 = d4;
                }
            }
            d3 = -d3;
            d = -d;
            return new IntersectionDistances(d, d3);
        }

        @Override
        public double[] getNormalVectorAtBoundary(double[] dArray) {
            DenseMatrix64F denseMatrix64F;
            double[] dArray2 = SymmetricMatrix.compoundCorrelationSymmetricMatrix(dArray, this.dim).toArrayComponents();
            DenseMatrix64F denseMatrix64F2 = DenseMatrix64F.wrap(this.dim, this.dim, dArray2);
            try {
                denseMatrix64F = EJMLUtils.computeRobustAdjugate(denseMatrix64F2);
            }
            catch (IllegalDimension illegalDimension) {
                illegalDimension.printStackTrace();
                throw new RuntimeException();
            }
            double[] dArray3 = new double[dArray.length];
            int n = 0;
            for (int i = 0; i < this.dim; ++i) {
                for (int j = i + 1; j < this.dim; ++j) {
                    dArray3[n] = denseMatrix64F.get(i, j);
                    ++n;
                }
            }
            return dArray3;
        }
    }
}

