/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.indel;

import dr.evolution.alignment.Alignment;
import dr.evolution.datatype.DataType;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.math.BFloat;
import dr.oldevomodel.indel.IntMathVec;
import dr.oldevomodel.indel.NativeTreeLikelihood;
import dr.oldevomodel.substmodel.SubstitutionModel;
import java.util.HashMap;

public class HomologyRecursion {
    IntMathVec[] iAlignment;
    int[][] iSequences;
    private int[] iParent;
    private double[] iTau;
    double iLambda;
    double iMu;
    int iNumNucs;
    double[][][] iTrans;
    double[] iEquil;
    private double[] iH;
    private double[] iN;
    private double[] iB;
    private double[] iE;
    private double iInitial;
    private NativeTreeLikelihood iNativeMethod;
    private static final int eFree = 0;
    private static final int ePossible = 1;
    private static final int eEdgeUsed = 2;
    private static final int eUsed = 3;
    private static final int cMaxUnalignDimension = 10;
    private static final double MIN_EDGE_LENGTH = 0.001;
    static int sBigUnalignableRegion = 0;

    String PrintDouble(double[] dArray) {
        String string = "";
        for (double d : dArray) {
            string = string + d + " ";
        }
        return string;
    }

    void checkConsistency() {
        int n;
        int n2;
        int n3 = this.iAlignment.length;
        int n4 = this.iAlignment[0].iV.length;
        String string = "";
        IntMathVec intMathVec = new IntMathVec(n4);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                if (this.iAlignment[n2].iV[n] == 0 || this.iAlignment[n2].iV[n] == 1) continue;
                string = "Non-0/1 emissions.";
            }
            intMathVec.add(this.iAlignment[n2]);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (this.iSequences[n2].length != intMathVec.iV[n2]) {
                string = "Bad sequences length";
            }
            for (n = 0; n < intMathVec.iV[n2]; ++n) {
                if (this.iSequences[n2][n] >= 0 && this.iSequences[n2][n] < this.iNumNucs) continue;
                string = "Nucleotide codes in iSequences not in range, " + this.iSequences[n2][n] + "not in [0," + (this.iNumNucs - 1) + "]";
            }
        }
        int[] nArray = new int[this.iParent.length];
        for (n = 0; n < this.iParent.length - 1; ++n) {
            int n5 = this.iParent[n];
            nArray[n5] = nArray[n5] + 1;
        }
        for (n = 0; n < n4; ++n) {
            if (nArray[n] == 0) continue;
            string = "Num tips does not correspond to num sequences, or bad tree";
        }
        for (n = n4; n < this.iParent.length; ++n) {
            if (nArray[n] == 2) continue;
            string = "Bad tree - not binary?  Or too many tips?";
        }
        if (this.iParent[this.iParent.length - 1] != -1) {
            string = "Bad tree - root not in final position, or not labeled -1";
        }
        for (n = 0; n < this.iParent.length - 1; ++n) {
            if (!(this.iTau[n] < 0.001)) continue;
            string = "";
            this.iTau[n] = 0.001;
        }
        if (!string.equals("")) {
            System.out.println(string);
        }
    }

    public void init(Tree tree, Alignment alignment, SubstitutionModel substitutionModel, double d, double d2, double d3) {
        this.initTree(tree, d);
        int[] nArray = new int[tree.getTaxonCount()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = tree.getTaxonIndex(alignment.getTaxonId(i));
        }
        this.initAlignment(alignment, nArray);
        this.initSequences(alignment, nArray);
        this.initSubstitutionModel(substitutionModel);
        this.iLambda = d3 * d2;
        this.iMu = d3;
        DataType dataType = substitutionModel.getDataType();
        this.iNumNucs = dataType.getStateCount();
        this.initTKF91();
        this.checkConsistency();
        this.iNativeMethod = new NativeTreeLikelihood();
        this.iNativeMethod.init(this.iNumNucs, 10, this.iParent, this.iEquil, this.iTrans, this.iSequences, this.iN, this.iH, this.iE, this.iB);
    }

    private void initTree(Tree tree, double d) {
        this.iParent = new int[tree.getNodeCount()];
        this.iTau = new double[tree.getNodeCount() - 1];
        this.populate(tree, tree.getRoot(), new int[]{tree.getExternalNodeCount()}, d);
        this.iParent[tree.getNodeCount() - 1] = -1;
    }

    private void initSubstitutionModel(SubstitutionModel substitutionModel) {
        int n;
        DataType dataType = substitutionModel.getDataType();
        int n2 = dataType.getStateCount();
        this.iTrans = new double[this.iTau.length][n2][n2];
        double[] dArray = new double[n2 * n2];
        for (n = 0; n < this.iTau.length; ++n) {
            substitutionModel.getTransitionProbabilities(this.iTau[n], dArray);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.iTrans[n][i][j] = dArray[n3];
                    ++n3;
                }
            }
        }
        this.iEquil = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.iEquil[n] = substitutionModel.getFrequencyModel().getFrequency(n);
        }
    }

    private void initAlignment(Alignment alignment, int[] nArray) {
        int n = alignment.getSequenceCount();
        int n2 = alignment.getSiteCount();
        DataType dataType = alignment.getDataType();
        int n3 = dataType.getStateCount();
        this.iAlignment = new IntMathVec[n2];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray2[nArray[j]] = alignment.getState(j, i) >= n3 ? 0 : 1;
            }
            this.iAlignment[i] = new IntMathVec(nArray2);
        }
    }

    private void initSequences(Alignment alignment, int[] nArray) {
        int n = alignment.getSequenceCount();
        DataType dataType = alignment.getDataType();
        int n2 = dataType.getStateCount();
        this.iSequences = new int[n][];
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            int n5 = 0;
            for (n4 = 0; n4 < alignment.getSiteCount(); ++n4) {
                n3 = alignment.getState(i, n4);
                if (n3 < 0 || n3 >= n2) continue;
                ++n5;
            }
            this.iSequences[nArray[i]] = new int[n5];
            n4 = 0;
            for (n3 = 0; n3 < alignment.getSiteCount(); ++n3) {
                int n6 = alignment.getState(i, n3);
                if (n6 < 0 || n6 >= n2) continue;
                this.iSequences[nArray[i]][n4] = n6;
                ++n4;
            }
        }
    }

    private int populate(Tree tree, NodeRef nodeRef, int[] nArray, double d) {
        int n;
        int n2 = nodeRef.getNumber();
        if (tree.isExternal(nodeRef)) {
            this.iTau[n2] = (tree.getNodeHeight(tree.getParent(nodeRef)) - tree.getNodeHeight(nodeRef)) * d;
            return n2;
        }
        int[] nArray2 = new int[tree.getChildCount(nodeRef)];
        for (n = 0; n < tree.getChildCount(nodeRef); ++n) {
            nArray2[n] = this.populate(tree, tree.getChild(nodeRef, n), nArray, d);
        }
        n2 = nArray[0];
        if (!tree.isRoot(nodeRef)) {
            this.iTau[n2] = (tree.getNodeHeight(tree.getParent(nodeRef)) - tree.getNodeHeight(nodeRef)) * d;
        }
        nArray[0] = nArray[0] + 1;
        for (n = 0; n < tree.getChildCount(nodeRef); ++n) {
            this.iParent[nArray2[n]] = n2;
        }
        return n2;
    }

    public void initTKF91() {
        int n = this.iParent.length;
        double[] dArray = new double[n];
        this.iB = new double[n];
        this.iE = new double[n];
        this.iH = new double[n];
        this.iN = new double[n];
        this.iInitial = 1.0;
        for (int i = 0; i < n; ++i) {
            if (i == n - 1) {
                dArray[i] = 1.0 / this.iMu;
                this.iH[i] = 0.0;
            } else {
                dArray[i] = Math.exp((this.iLambda - this.iMu) * this.iTau[i]);
                dArray[i] = (1.0 - dArray[i]) / (this.iMu - this.iLambda * dArray[i]);
                this.iH[i] = Math.exp(-this.iMu * this.iTau[i]) * (1.0 - this.iLambda * dArray[i]);
            }
            this.iB[i] = this.iLambda * dArray[i];
            this.iE[i] = this.iMu * dArray[i];
            this.iN[i] = (1.0 - this.iMu * dArray[i]) * (1.0 - this.iB[i]) - this.iH[i];
            this.iInitial *= 1.0 - this.iB[i];
        }
    }

    private double treeRecursion(IntMathVec intMathVec, IntMathVec intMathVec2) {
        int n;
        int n2;
        int n3;
        if (this.iNativeMethod.isAvailable()) {
            return this.iNativeMethod.treeRecursion(intMathVec, intMathVec2);
        }
        int n4 = intMathVec.iV.length;
        int n5 = this.iParent.length;
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[11];
        int[] nArray4 = new int[n5];
        int[] nArray5 = new int[n5];
        double[][] dArrayArray = new double[n5][];
        double[][] dArrayArray2 = new double[n5][];
        for (n3 = 0; n3 < n5; ++n3) {
            dArrayArray[n3] = new double[this.iNumNucs];
            dArrayArray2[n3] = new double[this.iNumNucs + 1];
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = intMathVec.iV[n3];
            nArray3[n6] = nArray3[n6] + 1;
            nArray[n3] = intMathVec.iV[n3];
            nArray2[n3] = intMathVec.iV[n3] == 0 ? 0 : 1;
        }
        n3 = 0;
        for (n2 = 0; n2 < n5 - 1; ++n2) {
            if (nArray2[n2] != nArray3[nArray[n2]] && nArray[n2] != 0) {
                if (nArray[this.iParent[n2]] == 0 || nArray[this.iParent[n2]] == nArray[n2]) {
                    nArray[this.iParent[n2]] = nArray[n2];
                    int n7 = this.iParent[n2];
                    nArray2[n7] = nArray2[n7] + nArray2[n2];
                } else {
                    n3 = 1;
                }
            }
            if (nArray4[this.iParent[n2]] == 0) {
                nArray4[this.iParent[n2]] = n2;
                continue;
            }
            nArray5[this.iParent[n2]] = n2;
        }
        if (n3 != 0) {
            return 0.0;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (intMathVec.iV[n2] == 0) {
                dArrayArray2[n2][this.iNumNucs] = 1.0;
                continue;
            }
            dArrayArray[n2][this.iSequences[n2][intMathVec2.iV[n2]]] = 1.0;
        }
        for (n2 = n4; n2 < n5; ++n2) {
            int n8;
            double d;
            int n9;
            if (nArray[n2] != 0 && nArray[n2] == nArray[nArray4[n2]] && nArray[n2] == nArray[nArray5[n2]]) {
                for (n9 = 0; n9 < this.iNumNucs; ++n9) {
                    double d2 = 0.0;
                    d = 0.0;
                    for (int i = 0; i < this.iNumNucs; ++i) {
                        d2 += dArrayArray[nArray4[n2]][i] * this.iH[nArray4[n2]] * this.iTrans[nArray4[n2]][n9][i];
                        d += dArrayArray[nArray5[n2]][i] * this.iH[nArray5[n2]] * this.iTrans[nArray5[n2]][n9][i];
                    }
                    dArrayArray[n2][n9] = d2 * d;
                }
                continue;
            }
            if (nArray[n2] != 0) {
                if (nArray[n2] == nArray[nArray4[n2]]) {
                    n9 = nArray4[n2];
                    n8 = nArray5[n2];
                } else {
                    n9 = nArray5[n2];
                    n8 = nArray4[n2];
                }
                for (n = 0; n < this.iNumNucs; ++n) {
                    d = 0.0;
                    double d3 = this.iE[n8] * dArrayArray2[n8][this.iNumNucs];
                    for (int i = 0; i < this.iNumNucs; ++i) {
                        d += dArrayArray[n9][i] * this.iH[n9] * this.iTrans[n9][n][i];
                        d3 += (dArrayArray[n8][i] + dArrayArray2[n8][i]) * (this.iN[n8] - this.iE[n8] * this.iB[n8]) * this.iEquil[i] + dArrayArray2[n8][i] * this.iH[n8] * this.iTrans[n8][n][i];
                    }
                    dArrayArray[n2][n] = d * d3;
                }
                continue;
            }
            n9 = nArray4[n2];
            n8 = nArray5[n2];
            for (n = 0; n < this.iNumNucs; ++n) {
                d = 0.0;
                double d4 = 0.0;
                double d5 = this.iE[n9] * dArrayArray2[n9][this.iNumNucs];
                double d6 = this.iE[n8] * dArrayArray2[n8][this.iNumNucs];
                for (int i = 0; i < this.iNumNucs; ++i) {
                    d += dArrayArray[n9][i] * this.iH[n9] * this.iTrans[n9][n][i];
                    d4 += dArrayArray[n8][i] * this.iH[n8] * this.iTrans[n8][n][i];
                    d5 += (dArrayArray[n9][i] + dArrayArray2[n9][i]) * (this.iN[n9] - this.iE[n9] * this.iB[n9]) * this.iEquil[i] + dArrayArray2[n9][i] * this.iH[n9] * this.iTrans[n9][n][i];
                    d6 += (dArrayArray[n8][i] + dArrayArray2[n8][i]) * (this.iN[n8] - this.iE[n8] * this.iB[n8]) * this.iEquil[i] + dArrayArray2[n8][i] * this.iH[n8] * this.iTrans[n8][n][i];
                }
                dArrayArray[n2][n] = d * d6 + d4 * d5;
                dArrayArray2[n2][n] = d5 * d6;
            }
            double d7 = dArrayArray2[n9][this.iNumNucs];
            double d8 = dArrayArray2[n8][this.iNumNucs];
            for (int i = 0; i < this.iNumNucs; ++i) {
                d7 -= this.iB[n9] * (dArrayArray2[n9][i] + dArrayArray[n9][i]) * this.iEquil[i];
                d8 -= this.iB[n8] * (dArrayArray2[n8][i] + dArrayArray[n8][i]) * this.iEquil[i];
            }
            dArrayArray2[n2][this.iNumNucs] = d7 * d8;
        }
        n2 = n5 - 1;
        double d = dArrayArray2[n2][this.iNumNucs];
        for (n = 0; n < this.iNumNucs; ++n) {
            d -= (dArrayArray2[n2][n] + dArrayArray[n2][n]) * this.iB[n2] * this.iEquil[n];
        }
        return d;
    }

    public double recursion() {
        int n = this.iAlignment.length;
        int n2 = this.iAlignment[0].iV.length;
        int n3 = 0;
        int[] nArray = new int[n];
        IntMathVec intMathVec = new IntMathVec(n2);
        HashMap<IntMathVec, BFloat> hashMap = new HashMap<IntMathVec, BFloat>();
        double d = this.treeRecursion(intMathVec, intMathVec);
        hashMap.put(intMathVec, new BFloat(this.iInitial / d));
        int[] nArray2 = new int[10];
        while (true) {
            boolean bl;
            int n4;
            IntMathVec intMathVec2 = new IntMathVec(n2);
            int n5 = 0;
            for (n4 = n3; intMathVec2.zeroEntry() && n4 < n; ++n4) {
                if (nArray[n4] == 3) continue;
                if (intMathVec2.innerProduct(this.iAlignment[n4]) == 0) {
                    nArray[n4] = 1;
                    if (n5 == 10) {
                        ++sBigUnalignableRegion;
                        System.err.println("We bailed out cause it was hairy: iNumPossible=" + n5);
                        return Double.NEGATIVE_INFINITY;
                    }
                    nArray2[n5++] = n4;
                }
                intMathVec2.add(this.iAlignment[n4]);
            }
            IntMathVec intMathVec3 = new IntMathVec(intMathVec);
            IntMathVec intMathVec4 = new IntMathVec(intMathVec.iV.length);
            do {
                BFloat bFloat;
                boolean bl2;
                bl = false;
                for (int i = n5 - 1; i >= 0; --i) {
                    int n6 = nArray2[i];
                    if (nArray[n6] == 1) {
                        nArray[n6] = 2;
                        intMathVec3.add(this.iAlignment[n6]);
                        intMathVec4.addMultiple(this.iAlignment[n6], i + 1);
                        bl = true;
                        i = 0;
                        continue;
                    }
                    nArray[n6] = 1;
                    intMathVec3.subtract(this.iAlignment[n6]);
                    intMathVec4.addMultiple(this.iAlignment[n6], -i - 1);
                }
                if (!bl) continue;
                BFloat bFloat2 = (BFloat)((BFloat)hashMap.get(intMathVec)).clone();
                BFloat bFloat3 = (BFloat)hashMap.get(intMathVec3);
                if (bFloat3 == null) {
                    bl2 = true;
                    bFloat = new BFloat(0.0f);
                } else {
                    bFloat = bFloat3;
                    bl2 = false;
                }
                double d2 = -this.treeRecursion(intMathVec4, intMathVec) / d;
                bFloat2.multiply(d2);
                bFloat.add(bFloat2);
                if (bl2) {
                    hashMap.put(intMathVec3.clone(), bFloat);
                    continue;
                }
                hashMap.put(intMathVec3, bFloat);
            } while (bl);
            --n4;
            while (n4 >= 0 && nArray[n4] != 1) {
                if (nArray[n4] == 3) {
                    intMathVec.subtract(this.iAlignment[n4]);
                    nArray[n4] = 0;
                }
                --n4;
            }
            if (n4 == -1) {
                return ((BFloat)hashMap.get(intMathVec3)).log();
            }
            nArray[n4] = 3;
            intMathVec.add(this.iAlignment[n4]);
            if (n4 > n3) continue;
            ++n3;
        }
    }
}

