% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryMaps.R
\name{summaryMaps}
\alias{summaryMaps}
\title{Create country-level summary maps of species and occurrence numbers}
\usage{
summaryMaps(
  data = NULL,
  class_n = 15,
  class_Style = "fisher",
  outPath = NULL,
  fileName = NULL,
  width = 10,
  height = 5,
  dpi = 300,
  returnPlot = FALSE,
  scale = 110,
  pointBuffer = 0.01
)
}
\arguments{
\item{data}{A data frame or tibble. Occurrence records as input.}

\item{class_n}{Numeric. The number of categories to break the data into.}

\item{class_Style}{Character. The class style passed to \code{\link[classInt:classIntervals]{classInt::classIntervals()}}. Options are chosen
style: one of "fixed", "sd", "equal", "pretty", "quantile", "kmeans", "hclust", "bclust",
"fisher", "jenks", "dpih", "headtails", or "maximum". Default = "fisher"}

\item{outPath}{A character vector the path to the save location for the output figure.}

\item{fileName}{A character vector with file name
for the output figure, ending with '.pdf'.}

\item{width}{Numeric. The width, in inches, of the resulting figure. Default = 10.}

\item{height}{Numeric. The height, in inches, of the resulting figure. Default = 5.}

\item{dpi}{Numeric. The resolution of the resulting plot. Default = 300.}

\item{returnPlot}{Logical. If TRUE, return the plot to the environment. Default = FALSE.}

\item{scale}{Numeric or character. Passed to rnaturalearth's ne_countries().
Scale of map to return, one of 110, 50, 10 or 'small', 'medium', 'large'. Default = 110.}

\item{pointBuffer}{Numeric. Amount to buffer points, in decimal degrees. If the point is outside
of a country, but within this point buffer, it will count towards that country. It's a good idea
to keep this value consistent with the prior flags applied. Default = 0.01.}
}
\value{
Saves a figure to the user-specified outpath and name with a global map of bee
occurrence species and count data from the input dataset.
}
\description{
Builds an output figure that shows the number of species and the number of occurrences per
country. Breaks the data into classes for visualisation. Users may filter data to their taxa
of interest to produce figures of interest.
}
\examples{
# Read in data
data(beesFlagged)
OutPath_Figures <- tempdir()
# This simple example using the test data has very few classes due to the small amount of input 
# data.
summaryMaps(
data = beesFlagged,
width = 10, height = 10,
class_n = 4,
class_Style = "fisher",
outPath = OutPath_Figures,
fileName = paste0("CountryMaps_fisher_TEST.pdf"),
)


}
