% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readData.R
\name{concCst}
\alias{concCst}
\title{Recalculate the concentrations for the chronic oral tests for bees from
mg a.s./kg feed to \eqn{\mu}g/bee}
\usage{
concCst(cExt, f_rate = c(25), targConc = 1, cstConcCal = TRUE, ...)
}
\arguments{
\item{cExt}{The concentration dataframe in mg a.s./kg feed}

\item{f_rate}{A vector containing the feeding rates of the bees in mg/bee/day. If the vector
is of size 1, the same feeding rate is used for all test conditions. If the vector
is of size >1, it should be of the same size as the number of condition and one
feeding rate must be provided per condition. Default is 25 mg/bee/day}

\item{targConc}{A numerical scalar representing the unit of the target concentration amongst (default = 1)
\itemize{
\item \code{1} for \eqn{\mu}g a.s./bee
\item \code{2} for ng a.s./bee
\item \code{3} for mg a.s./bee
}}

\item{cstConcCal}{Logical. Indicate if concentrations should be recalculated from
mg a.s./kg feed to Xg/bee}

\item{...}{Not used}
}
\value{
A data frame containing a column with the time points and a column with the
recalculated concentrations
}
\description{
Recalculate the concentrations for the chronic oral tests for bees from
mg a.s./kg feed to \eqn{\mu}g/bee
}
\examples{
cExt <- data.frame(SurvivalTime = c(0,10), Control = c(0,0),
        T1 = c(1, 1), T2 = c(5, 5), Dataset = c(1, 1))
conc <- concCst(cExt, targConc = 2)
}
