% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{bevimed}
\alias{bevimed}
\title{Bayesian Evaluation of Variant Involvement in Mendelian Disease}
\usage{
bevimed(y, G, ploidy = rep(2L, length(y)), prior_prob_association = 0.01,
  prior_prob_dominant = 0.5, dominant_args = NULL, recessive_args = NULL,
  ...)
}
\arguments{
\item{y}{Logical vector of case (\code{TRUE}) control (\code{FALSE}) status.}

\item{G}{Integer matrix of variant counts per individual, one row per individual and one column per variant.}

\item{ploidy}{Integer vector giving ploidy of samples.}

\item{prior_prob_association}{The prior probability of association.}

\item{prior_prob_dominant}{The prior probability of dominant inheritance given that there is an association.}

\item{dominant_args}{Arguments to pass to \code{\link{bevimed_m}} conditioning on dominant inheritance.}

\item{recessive_args}{Arguments to pass to \code{\link{bevimed_m}} conditioning on recessive inheritance.}

\item{...}{Arguments to be passed to \code{\link{bevimed_m}} for both modes of inheritance.}
}
\value{
\code{BeviMed} object containing results of inference.
}
\description{
Infer probabilities of association between disease label and locus and posterior parameter values under BeviMed model.
}
\seealso{
\code{\link{prob_association}}, \code{\link{bevimed_m}}, \code{\link{summary.BeviMed}}, \code{\link{bevimed_polytomous}}
}

