% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bSCMdeConfoundingGraphFunc.R
\name{bSCMdeConfoundingGraphFunc}
\alias{bSCMdeConfoundingGraphFunc}
\title{bSCMdeConfoundingGraphFunc function}
\usage{
bSCMdeConfoundingGraphFunc(dat, IndpThs = 0.05, alpha = 0.05)
}
\arguments{
\item{dat}{is the result of inferring dependencies between all pairs of variables from \code{bSCMDepndentGraphFunc()}.}

\item{IndpThs}{is a threshold for the degree of dependency. In the independence test, to claim that any variables are dependent, the dependency degree must greater than this value significantly. The default is 0.05.}

\item{alpha}{is a significance threshold for hypothesis tests (Mann Whitney)
that deploys for testing degrees of dependency, association direction, and causal direction. The default is 0.5.}
}
\value{
This function returns an adjacency matrix of dependencies that have no confounding factors.
\item{E1}{An adjacency matrix of undirected graph after filtering associations without true causal directions from any confounding factor.}
\item{E2}{A matrix of associations that have confounding factors where \code{E2[i,j]=0} if no confounding factor and \code{E2[i,j]=k} if k is a confounding factor of i and j.}
}
\description{
This function removes any association/dependency of variables i,j that have any confounding factor k s.t. given k, i and j are independent.
}
\examples{
bSCMdeConfoundingGraphFunc(resC$depRes)

}
