% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdget_maf_hdf5}
\alias{bdget_maf_hdf5}
\title{Get minor allele frequency}
\usage{
bdget_maf_hdf5(
  filename,
  group,
  dataset,
  byrows = NULL,
  bparallel = NULL,
  wsize = NULL
)
}
\arguments{
\item{filename}{string file name where dataset to normalize is stored}

\item{group}{string Matrix}

\item{dataset}{string  Matrix}

\item{byrows, }{boolean, default TRUE. If true, the frequency is calculated by rows, else, if byrows= FALSE, frequency is calculated by columns}

\item{bparallel, }{boolean, Perform calculous in parallel?, by default TRUE.}

\item{wsize}{integer (default = 1000), file block size to read to perform normalization}
}
\value{
Numeric vector with allele frequencies
}
\description{
This function normalize data scaling, centering or scaling and centering in a dataset stored in hdf5 file
}
\examples{

library(BigDataStatMeth)

maf_cols = resc <- bdget_maf_hdf5("/Users/mailos/tmp/test/test.hdf5", 
                                          "test", "mat1", byrows = FALSE )
maf_rows = resc <- bdget_maf_hdf5("/Users/mailos/tmp/test/test.hdf5", 
                                          "test", "mat1", byrows = TRUE )

}
