\name{symbolic_to_relprob_matrix_sp}
\alias{symbolic_to_relprob_matrix_sp}
\title{Convert symbolic matrix (with text equations) to relprob matrix (numeric values) -- speciation matrix version}
\usage{
  symbolic_to_relprob_matrix_sp(spmat, cellsplit = "\\\\+",
    mergesym = "*", ys = 1, j = 0, v = 1,
    maxent_constraint_01 = 1e-04,
    maxent_constraint_01v = 1e-04, max_numareas = 6, ...)
}
\arguments{
  \item{spmat}{The speciation/cladogenesis matrix, with
  text formula.}

  \item{cellsplit}{The symbol to split the formulas on.
  Default "\\\\+" (plus symbol, with escape code).}

  \item{mergesym}{The symbol to merge the formulas with.
  Default "+".}

  \item{ys}{Relative weight of fully sympatric speciation
  (range-copying) and sympatric "subset" speciation.
  Default \code{s=1} mimics LAGRANGE model.}

  \item{v}{Relative weight of vicariant speciation. Default
  \code{v=1} mimics LAGRANGE model.}

  \item{j}{Relative weight of "founder event
  speciation"/jump speciation. Default \code{j=0} mimics
  LAGRANGE model.}

  \item{maxent_constraint_01}{Parameter which assigns
  relative probabilities to different descendants range
  sizes, for the smaller descendant. Values can range from
  0.0001 to 1. If \code{maxent_constraint_01=0.0001}, then
  the smaller descendant has a range size of 1 with
  probability 1 (i.e., the \code{LAGRANGE} default). If
  \code{maxent_constraint_01=0.5}, then all range sizes are
  equally weighted.  If \code{maxent_constraint_01=1}, then
  the largest possible smaller descendant gets probability
  1.  The reference to "maxent" derives from the fact that
  the maxent probability distribution on a multistate,
  ordered, discrete variable -- e.g. a die roll -- can be
  calculated given just the mean value.  Here, the
  \code{maxent_constraint_01} parameter is multiplied by
  the (maximum rangesize + 1).  Thus, when
  \code{maxent_constraint_01=0.5}, if there are 6 possible
  states, then the parameter becomes 3.5, which sets equal
  probabilities of all possible descendant ranges sizes,
  when range size can range from 1 to 6.}

  \item{maxent_constraint_01v}{Works the same as
  \code{maxent_constraint_01}, but just for descendants of
  vicariant events.}

  \item{max_numareas}{The maximum number of areas possible
  allowed for the smaller-ranged-daughter in either
  vicariant or sympatric types of cladogenesis/speciation.}

  \item{...}{Additional arguments to pass to
  \code{\link{relative_probabilities_of_subsets}} and
  \code{\link{relative_probabilities_of_vicariants}}, and
  thence to \code{\link[base]{strsplit}}.}
}
\value{
  \code{cellval} The output cell value.
}
\description{
  This does the equivalent of
  \code{\link{symbolic_to_P_matrix}}, but for a
  speciation/cladogenesis matrix.
}
\details{
  These are 1-event probability matrices, not instantaneous
  rate matrices.

  This function uses
  \code{\link{symbolic_cell_to_relprob_cell_sp}} in an
  \code{\link[base]{sapply}} call.  It still will not be
  very fast compared to the calculations in
  \code{\link[cladoRcpp]{cladoRcpp}}, but can be useful for
  demonstrative purposes.
}
\note{
  Go BEARS!
}
\examples{
testval=1
# Generate the text version of the speciation/cladogenesis probability matrix
# (actually a relative weights matrix
# until the rows are normalized so that each sums to 1).
spmat = make_relprob_matrix_bi(states_list=list("_", c("A"), c("B"), c("C"),
c("A","B"), c("B","C"), c("A","C"), c("A","B","C")), split_ABC=FALSE, splitval="",
code_for_overlapping_subsets=NA, printwarn=1)
spmat

# Look at the conditional probabilities generated by a variety of models
spPmat = symbolic_to_relprob_matrix_sp(spmat=spmat, cellsplit="\\\\\\\\+", mergesym="*",
ys=1, j=0, v=1, maxent_constraint_01=0.0001, maxent_constraint_01v=0.0001,
max_numareas=3)
spPmat = adf(spPmat); names(spPmat) = names(spmat); rownames(spPmat) = rownames(spmat)
spPmat

spPmat = symbolic_to_relprob_matrix_sp(spmat=spmat, cellsplit="\\\\\\\\+",
mergesym="*", ys=0.5, j=0, v=0.5, maxent_constraint_01=0.0001,
maxent_constraint_01v=0.0001, max_numareas=3)
spPmat = adf(spPmat); names(spPmat) = names(spmat); rownames(spPmat) = rownames(spmat)
spPmat

spPmat = symbolic_to_relprob_matrix_sp(spmat=spmat, cellsplit="\\\\\\\\+",
mergesym="*", ys=1, j=1, v=1, maxent_constraint_01=0.0001,
maxent_constraint_01v=0.0001, max_numareas=3)
spPmat = adf(spPmat); names(spPmat) = names(spmat); rownames(spPmat) = rownames(spmat)
spPmat

spPmat = symbolic_to_relprob_matrix_sp(spmat=spmat, cellsplit="\\\\\\\\+",
mergesym="*", ys=0.25, j=0.25, v=0.25, maxent_constraint_01=0.0001,
maxent_constraint_01v=0.0001, max_numareas=3)
spPmat = adf(spPmat); names(spPmat) = names(spmat); rownames(spPmat) = rownames(spmat)
spPmat

spPmat = symbolic_to_relprob_matrix_sp(spmat=spmat, cellsplit="\\\\\\\\+",
mergesym="*", ys=1, j=1, v=0, maxent_constraint_01=0.0001,
maxent_constraint_01v=0.0001, max_numareas=3)
spPmat = adf(spPmat); names(spPmat) = names(spmat); rownames(spPmat) = rownames(spmat)
spPmat

spPmat = symbolic_to_relprob_matrix_sp(spmat=spmat, cellsplit="\\\\\\\\+",
mergesym="*", ys=1, j=1, v=0, maxent_constraint_01=0.5,
maxent_constraint_01v=0.0001, max_numareas=3)
spPmat = adf(spPmat); names(spPmat) = names(spmat); rownames(spPmat) = rownames(spmat)
spPmat

spPmat = symbolic_to_relprob_matrix_sp(spmat=spmat, cellsplit="\\\\\\\\+",
mergesym="*", ys=1, j=0, v=0, maxent_constraint_01=0.5,
maxent_constraint_01v=0.0001, max_numareas=3)
spPmat = adf(spPmat); names(spPmat) = names(spmat); rownames(spPmat) = rownames(spmat)
spPmat

spPmat = symbolic_to_relprob_matrix_sp(spmat=spmat, cellsplit="\\\\\\\\+",
mergesym="*", ys=1, j=0, v=1, maxent_constraint_01=0.0001,
maxent_constraint_01v=0.5, max_numareas=3)
spPmat = adf(spPmat); names(spPmat) = names(spmat); rownames(spPmat) = rownames(spmat)
spPmat
}
\author{
  Nicholas J. Matzke \email{matzke@berkeley.edu}
}
\references{
  \url{http://phylo.wikidot.com/matzke-2013-international-biogeography-society-poster}
  \url{https://code.google.com/p/lagrange/}

  Matzke_2012_IBS

  ReeSmith2008
}
\seealso{
  \code{\link{symbolic_cell_to_relprob_cell_sp}},
  \code{\link{make_relprob_matrix_de}}
}

