workdir <- tempdir()
dir.create(sprintf("%s/tmp/", workdir))
dir.create(sprintf("%s/tmp1/", workdir))
test.file <- sprintf("%s/tmp1/test", workdir)
file.create(test.file)
gzip(test.file)
flog.info("Debug:extract.file()")
print(extract.file(sprintf("%s.gz", test.file), paste0(workdir, "/tmp")))

file.create(test.file)
gzip(test.file)
flog.info("Debug:extract.file()")
print(extract.file(sprintf("%s.gz", test.file), paste0(workdir, "/tmp"), decompress = FALSE))

test.dir <- sprintf("%s/test_drop", tempdir())
dir.create(test.dir)
dir.create(sprintf("%s/a", test.dir))
dir.create(sprintf("%s/a/b", test.dir))
dir.create(sprintf("%s/a/c", test.dir))
flog.info("Debug:drop_redundance_dir")
print(drop_redundance_dir(test.dir))

flog.info("Debug:install.bioinfo(show,all.names = T)")
print(install.bioinfo(show.all.names = T))
flog.info("Debug:is.file.empty(tempdir())")
print(is.file.empty(tempdir()))
flog.info("Debug:get.os()")
print(get.os())

flog.info("Debug:set.makedir('test_makedir', sprintf('%s/non_exists', tempdir()))")
print(set.makedir("%s/test_makedir", sprintf("%s/non_exists", tempdir())))
