% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/401-extractDrugALOGP.R
\name{property}
\alias{property}
\alias{extrDrugALOGP}
\alias{extrDrugApol}
\alias{extrDrugBPol}
\alias{extrDrugHBondAcceptorCount}
\alias{extrDrugHBondDonorCount}
\alias{extrDrugRuleOfFive}
\alias{extrDrugTPSA}
\alias{extrDrugWeight}
\alias{extrDrugLogP}
\title{Calculates Atom Additive logP and Molar Refractivity Values Descriptor}
\usage{
extrDrugALOGP(molecules, silent = TRUE)

extrDrugApol(molecules, silent = TRUE)

extrDrugBPol(molecules, silent = TRUE)

extrDrugHBondAcceptorCount(molecules, silent = TRUE)

extrDrugHBondDonorCount(molecules, silent = TRUE)

extrDrugRuleOfFive(molecules, silent = TRUE)

extrDrugTPSA(molecules, silent = TRUE)

extrDrugWeight(molecules, silent = TRUE)

extrDrugLogP(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process 
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules, 
each column represents one feature. This function returns three columns 
named \code{ALogP}, \code{ALogp2} and \code{AMR}.
}
\description{
Calculates Atom Additive logP and Molar Refractivity Values Descriptor

Calculates the Sum of the Atomic Polarizabilities Descriptor

Calculates the Descriptor that Describes the Sum of the Absolute 
Value of the Difference between Atomic Polarizabilities of 
All Bonded Atoms in the Molecule

Descriptor that Calculates the Number of Hydrogen Bond Acceptors

Descriptor that Calculates the Number of Hydrogen Bond Donors

Descriptor that Calculates the Number Failures of the Lipinski's Rule Of Five

Descriptor of Topological Polar Surface Area Based on 
Fragment Contributions (TPSA)

Descriptor that Calculates the Total Weight of Atoms

Descriptor that Calculates the Prediction of logP 
Based on the Atom-Type Method Called XLogP
}
\details{
Calculates ALOGP (Ghose-Crippen LogKow) and the Ghose-Crippen molar 
refractivity as described by Ghose, A.K. and Crippen, G.M. 
Note the underlying code in CDK assumes that aromaticity 
has been detected before evaluating this descriptor. 
The code also expects that the molecule will have 
hydrogens explicitly set. For SD files, this is 
usually not a problem since hydrogens are explicit. 
But for the case of molecules obtained from SMILES, 
hydrogens must be made explicit.

Calculates the sum of the atomic polarizabilities 
(including implicit hydrogens) descriptor. 
Polarizabilities are taken from 
\url{https://doi.org/10.1063/1.459444}.

This descriptor calculates the sum of the absolute value of the 
difference between atomic polarizabilities of all bonded atoms 
in the molecule (including implicit hydrogens) with polarizabilities 
taken from \url{https://doi.org/10.1063/1.459444}.
This descriptor assumes 2-centered bonds.

This descriptor calculates the number of hydrogen bond acceptors 
using a slightly simplified version of the PHACIR atom types. 
The following groups are counted as hydrogen bond acceptors:
any oxygen where the formal charge of the oxygen is 
non-positive (i.e. formal charge <= 0) except
\enumerate{
\item an aromatic ether oxygen (i.e. an ether oxygen that is 
adjacent to at least one aromatic carbon)
\item an oxygen that is adjacent to a nitrogen
}
and any nitrogen where the formal charge of the nitrogen is 
non-positive (i.e. formal charge <= 0) except a nitrogen 
that is adjacent to an oxygen.

This descriptor calculates the number of hydrogen bond donors using 
a slightly simplified version of the PHACIR atom types 
(\url{http://www.rguha.net/code/java/cdkdesc.html}). 
The following groups are counted as hydrogen bond donors:
\itemize{
\item Any-OH where the formal charge of the oxygen is non-negative 
(i.e. formal charge >= 0)
\item Any-NH where the formal charge of the nitrogen is non-negative 
(i.e. formal charge >= 0)
}

This descriptor calculates the number failures of the Lipinski's Rule Of Five:
\url{https://en.wikipedia.org/wiki/Lipinski\%27s_Rule_of_Five}.

Calculate the descriptor of topological polar surface area 
based on fragment contributions (TPSA).

This descriptor calculates the molecular weight.

Prediction of logP based on the atom-type method called XLogP.
}
\examples{
# Calculates Atom Additive logP and Molar Refractivity Values Descriptor
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugALOGP(mol)
head(dat)

# Calculates the Sum of the Atomic Polarizabilities Descriptor
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugApol(mol)
head(dat)

# the Sum of the Absolute Value of the Difference between Atomic 
# Polarizabilities of All Bonded Atoms in the Molecule
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugBPol(mol)
head(dat)

# Calculates the Number of Hydrogen Bond Acceptors
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugHBondAcceptorCount(mol)
head(dat)

# Calculates the Number of Hydrogen Bond Donors
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugHBondDonorCount(mol)
head(dat)

# Calculates the Number Failures of the Lipinski's Rule Of Five
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugRuleOfFive(mol)
head(dat)

# Descriptor of Topological Polar Surface Area Based on 
# Fragment Contributions (TPSA)
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugTPSA(mol)
head(dat)

# Calculates the Total Weight of Atoms
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugWeight(mol)
head(dat)

# Calculates the Prediction of logP 
# Based on the Atom-Type Method Called XLogP
smi = system.file('vignettedata/test.smi', package = 'BioMedR')
mol = readMolFromSmi(smi, type = 'mol')
dat = extrDrugLogP(mol)
head(dat)

}
\references{
Ghose, A.K. and Crippen, G.M. , 
Atomic physicochemical parameters for three-dimensional structure-directed 
quantitative structure-activity relationships. 
I. Partition coefficients as a measure of hydrophobicity, 
Journal of Computational Chemistry, 1986, 7:565-577.

Ghose, A.K. and Crippen, G.M. , 
Atomic physicochemical parameters for three-dimensional-structure-directed 
quantitative structure-activity relationships. 
2. Modeling dispersive and hydrophobic interactions, 
Journal of Chemical Information and Computer Science, 1987, 27:21-35.

Ertl, P., Rohde, B., & Selzer, P. (2000). 
Fast calculation of molecular polar surface area as a sum of 
fragment-based contributions and its application to the prediction 
of drug transport properties. 
Journal of medicinal chemistry, 43(20), 3714-3717.

Wang, R., Fu, Y., and Lai, L., 
A New Atom-Additive Method for Calculating Partition Coefficients, 
Journal of Chemical Information and Computer Sciences, 1997, 37:615-621.

Wang, R., Gao, Y., and Lai, L., 
Calculating partition coefficient by atom-additive method, 
Perspectives in Drug Discovery and Design, 2000, 19:47-66.
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{ALOGP}
\keyword{Acceptor}
\keyword{Apol}
\keyword{Area}
\keyword{BPol}
\keyword{Bond}
\keyword{Count}
\keyword{Donor}
\keyword{Five}
\keyword{HBond}
\keyword{Lipinski}
\keyword{Polar}
\keyword{Polarizability}
\keyword{Rule}
\keyword{Surface}
\keyword{Topological}
\keyword{Weight}
\keyword{XLogP}
\keyword{extrDrugALOGP}
\keyword{extrDrugApol}
\keyword{extrDrugBPol}
\keyword{extrDrugHBondAcceptorCount}
\keyword{extrDrugHBondDonorCount}
\keyword{extrDrugLogP}
\keyword{extrDrugRuleOfFive}
\keyword{extrDrugTPSA}
\keyword{extrDrugWeight}
