% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/523-extractProtPSSMAcc.R
\name{extrProtPSSMAcc}
\alias{extrProtPSSMAcc}
\title{Profile-based protein representation derived by PSSM 
(Position-Specific Scoring Matrix) and auto cross covariance}
\usage{
extrProtPSSMAcc(pssmmat, lag)
}
\arguments{
\item{pssmmat}{The PSSM computed by \code{\link{extrProtPSSM}}.}

\item{lag}{The lag parameter. Must be less than the number of amino acids 
in the sequence (i.e. the number of columns in the PSSM matrix).}
}
\value{
A length \code{lag * 20^2} named numeric vector,
the element names are derived by the amino acid name abbreviation
(crossed amino acid name abbreviation) and lag index.
}
\description{
Profile-based protein representation derived by PSSM 
(Position-Specific Scoring Matrix) and auto cross covariance
}
\details{
This function calculates the feature vector based on the PSSM 
by running PSI-Blast and auto cross covariance tranformation.
}
\examples{
\donttest{
x = readFASTA(system.file('protseq/P00750.fasta', package = 'BioMedR'))[[1]]
dbpath = tempfile('tempdb', fileext = '.fasta')
invisible(file.copy(from = system.file('protseq/Plasminogen.fasta', 
package = 'BioMedR'), to = dbpath))
pssmmat = extrProtPSSM(seq = x, database.path = dbpath)
pssmacc = extrProtPSSMAcc(pssmmat, lag = 3)
tail(pssmacc)
}

}
\references{
Wold, S., Jonsson, J., Sj\"{o}rstr\"{o}m, M., Sandberg, 
M., & R\"{a}nnar, S. (1993). 
DNA and peptide sequences and chemical processes multivariately modelled 
by principal component analysis and partial least-squares projections 
to latent structures. 
\emph{Analytica chimica acta}, 277(2), 239--253.
}
\seealso{
\link{extrProtPSSM} \link{extrProtPSSMFeature}
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{Alignment}
\keyword{Blast}
\keyword{PSSM}
\keyword{extract}
