% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment_simulation.R
\name{enrichment_simulation}
\alias{enrichment_simulation}
\title{Prognostic Enrichment with Simulated Data}
\usage{
enrichment_simulation(baseline.event.rate, reduction.under.treatment,
  estimated.auc, roc.type = NULL, cost.screening = NULL,
  cost.keeping = NULL, simulation.sample.size = 5e+05,
  alternative = c("one.sided", "two.sided"), power = 0.9, alpha = 0.025,
  selected.biomarker.quantiles = seq(from = 0, to = 95, by = 5))
}
\arguments{
\item{baseline.event.rate}{A number between 0 and 1 indicating the prevalence of the event in the study population.}

\item{reduction.under.treatment}{A number between 0 and 1 indicating the percent reduction in event rate under treatment that the trial should be able to detect with the specified power.}

\item{estimated.auc}{A numeric vector, with each entry between 0.5 and 1, that specifies the AUC for each biomarker to use in simulations.}

\item{roc.type}{A character vector with the same length as the estimated.auc argument. Each entry must be one of "symmetric", "right.shifted", or "left.shifted", which describes the general shape of the ROC curve to use for simulated data. Defaults to "symmetric" for each biomarker.}

\item{cost.screening}{A positive number indicating the cost of screening a patient to determine trial eligibility, This argument is optional; if both cost.screening and cost.keeping are specified, then then the total cost of the trial based on each screening threshold is estimated and returned.}

\item{cost.keeping}{A positive number indicating the cost of retaining a patient in the trial after enrolling. This argument is optional; if both cost.screening and cost.keeping are specified, then then the total cost of the trial based on each screening threshold is estimated and returned.}

\item{simulation.sample.size}{A positive number giving the sample size to use for simulated data. Defaults to 500,000 (to help see trends).}

\item{alternative}{Character specifying whether the alternative hypothesis is one-sided (``one.sided'') with a higher outcome probability in the treatment group or two-sided (``two.sided''). Defaults to ``one.sided''.}

\item{power}{Number between 0 and 1 giving the power the trial should have to reject the null hypothesis that there is no treatment effect. Defaults to 0.9.}

\item{alpha}{Number between 0 and 1 giving the type I error rate for testing the null hypothesis that there is no treatment effect.  Defaults to 0.025.}

\item{selected.biomarker.quantiles}{Numeric vector specifying the quantiles of the biomarker measured in controls that will be used to screen trial participants. Defaults to 0, 5, ..., 95. All entries must be between at least 0 and less than 001.}
}
\value{
A list with components
\itemize{
  \item estimates: A data frame with the following summary measures for each biomarker threshold that is used to screen trial participants: `selected.biomarker.quantiles': quantiles of observed biomarker values used for screening. `biomarker.screening.thresholds': the values of the biomarker corresponding to the quantiles, `event.rate': post-screening event rate, `NNS': The estimated number of patients needed to screen to identify one patient eligible for the trial, `SS': The sample size in a clinical trial enrolling only patients whose biomarker-based disease risk is above the level used for screening, `N.screen': The total number of individuals whose biomarker values are screened to determine whether they should be enrolled in the trial, `N.screen.increase.percentage': Percentage in N.screen relative to a trail that does not based on the biomarker. `total.cost': The estimated total cost of running the trial if the biomarker were used for prognostic enrichment (if cost.screening and cost.keeping are specified), `cost.reduction.percentage': The reduction in total cost relative to a trial that does not screen based on the biomarker. `Biomarker': label for the biomarker. 
  \item simulation: Logical indicating whether data were simulated (always TRUE for the \code{\link{plot_enrichment_summaries}} function).
}
}
\description{
Evaluating biomarkers for prognostic enrichment of clinical trials using simulated data
}
\examples{
## three biomarkers with symmetric ROC curves
simulation.three.markers <- enrichment_simulation(baseline.event.rate=0.2,
reduction.under.treatment=0.3,
estimated.auc=c(0.72, 0.82, 0.85),
roc.type=c("symmetric", "symmetric", "symmetric"),
cost.screening=1,
cost.keeping=10,
simulation.sample.size=1e+5)
head(simulation.three.markers$estimates)

}
\seealso{
\code{\link{enrichment_analysis}}, \code{\link{plot_enrichment_summaries}}
}

