% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgCorr.R
\name{bgCorr}
\alias{bgCorr}
\title{Background noise correction of expression data}
\usage{
bgCorr(exprmat)
}
\arguments{
\item{exprmat}{A numeric matrix with time-series expression data with variables as rownames.}
}
\value{
Returns background noise corrected expression matrix.
}
\description{
This helper function performs a background noise correction before subjecting the corrected matrix to the peakDetection
function. Genes with an expression lower than the 5 % quantile of the entire expression matrix are discarded.
}
\examples{
# Example based on the heat-shock dataset
data(heat)
heat = as.matrix(heat)
# Execute the bgCorr function
exprmat_corrected <- bgCorr(heat)

}
\author{
David Lauenstein
}
