% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kendall.SNBP.R
\name{Kendall.SNBP}
\alias{Kendall.SNBP}
\title{Kendall's tau under the SNBP distribution}
\usage{
Kendall.SNBP(Alpha0, Alpha1, Alpha2, Gamma)
}
\arguments{
\item{Alpha0}{Copula parameter \eqn{\alpha_{0}} with restricted range.}

\item{Alpha1}{Positive scale parameter \eqn{\alpha_{1}} for the Pareto margin.}

\item{Alpha2}{Positive scale parameter \eqn{\alpha_{2}} for the Pareto margin.}

\item{Gamma}{Common positive shape parameter \eqn{\gamma} for the Pareto margins.}
}
\value{
\item{tau}{Kendall's tau.}
}
\description{
Compute Kendall's tau under the Sankaran and Nair bivairate Pareto (SNBP) distribution (Sankaran and Nair, 1993) by numerical integration.
}
\details{
The admissible range of \code{Alpha0} (\eqn{\alpha_{0}}) is \eqn{0 \leq \alpha_{0} \leq (\gamma+1) \alpha_{1} \alpha_{2}.}
}
\examples{
library(Bivariate.Pareto)
Kendall.SNBP(7e-5,0.0036,0.0075,1.8277)
}
\references{
Sankaran and Nair (1993), A bivariate Pareto model and its applications to reliability, Naval Research Logistics, 40(7): 1013-1020.

Shih et al. (2018), Fitting competing risks data to bivariate Pareto models, Communications in Statistics - Theory and Methods, doi: 10.1080/03610926.2018.1425450.
}
