% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population.test.MinPv.R
\name{population.test.MinPv}
\alias{population.test.MinPv}
\title{The one-sample population inference using Genovese and Wasserman's method}
\usage{
population.test.MinPv(popEst, alpha = 0.05, c0 = 0.1)
}
\arguments{
\item{popEst}{A \code{popEst} class object.}

\item{alpha}{significance level, default value is \code{0.05}.}

\item{c0}{threshold of the exceedance rate of the false discovery proportion (FDP),
default value is \code{0.1}.}
}
\value{
A  \eqn{p*p} matrix with values 0 or 1.
}
\description{
Identify the nonzero partial correlations in one-sample population,
based on controlling the exceedance rate of the false discovery proportion (FDP)
at \eqn{\alpha=0.05}. The method is based on the minimum of the p-values.
Input  data \eqn{Z} , contains values of p interested variables.
\cr
\cr
}
\examples{
## Quick example for the one-sample population inference
data(popsimA)
pc = population.est(popsimA)            # estimating partial correlation coefficients
Res  = population.test.MinPv(pc)        # conducting hypothesis test

}
\references{
Genovese C., and Wasserman L. (2006).
Exceedance Control of the False Discovery Proportion,
\emph{Journal of the American Statistical Association}, 101, 1408-1417

Qiu Y. and Zhou X. (2021).
Inference on multi-level partial correlations
based on multi-subject time series data,
\emph{Journal of the American Statistical Association}, 00, 1-15
}
