% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_brazil_municipalities.R
\name{get_brazil_municipalities}
\alias{get_brazil_municipalities}
\title{Get Municipalities of a Brazilian State from IBGE}
\usage{
get_brazil_municipalities(uf)
}
\arguments{
\item{uf}{A two-letter string representing the Brazilian state abbreviation (e.g., "SP", "RJ", "BA").}
}
\value{
A data frame (tibble) with the following columns:
\itemize{
  \item \code{nome}: Name of the municipality.
  \item \code{codigo_ibge}: Official IBGE code for the municipality (as character).
}
}
\description{
This function retrieves a list of municipalities from the Brazilian IBGE API using
the state abbreviation (UF). It includes the name of each municipality and its official
IBGE code.
}
\details{
The function sends a GET request to the BrasilAPI IBGE endpoint. If the UF (state abbreviation)
is invalid or not recognized, the function returns \code{NULL} with an appropriate message.
}
\note{
Requires internet access. Official IBGE codes are widely used for geostatistical analysis
and identification of Brazilian municipalities.
}
\examples{
\dontrun{
municipalities_sp <- get_brazil_municipalities("SP")
head(municipalities_sp)
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
