% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables_air_humidity_2.R
\name{es_ea_calculation}
\alias{es_ea_calculation}
\title{Vapour pressure deficit (es - ea)}
\usage{
es_ea_calculation(tmin, tmax, tdew, rh_min, rh_mean, rh_max, ea_method)
}
\arguments{
\item{tmin}{A dataframe with minimum daily air temperature (°C).}

\item{tmax}{A dataframe with maximum daily air temperature (°C).}

\item{tdew}{A dataframe with dewpoint temperature (°C).}

\item{rh_min}{A dataframe with minimum daily relative air humidity (percentage).}

\item{rh_mean}{A dataframe with mean daily relative air humidity (percentage).}

\item{rh_max}{A dataframe with maximum daily relative air humidity (percentage).}

\item{ea_method}{The methodology to calculate the actual vapour pressure. Assume the "rh" (default) for relative humidity procedure and "dew" for dewpoint temperature procedure.}
}
\value{
Returns a data.frame object with the ea from relative humidity data.
}
\description{
Vapour pressure deficit (es - ea)
}
\examples{
\dontrun{
ea <- es_ea_calculation(tmin, tmax, tdew, rh_min, rh_mean, rh_max, ea_method)
}
}
\author{
Roberto Filgueiras, Luan P. Venancio, Catariny C. Aleman and Fernando F. da Cunha
}
