% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuddleMain.R
\name{CheckNonNumeric}
\alias{CheckNonNumeric}
\title{Detecting Non-numeric Values.}
\usage{
CheckNonNumeric(X)
}
\arguments{
\item{X}{an n-by-p matrix.}
}
\value{
A list of (n+1) values where n is the number of non-numeric values. The first element of the list is n, and all other elements are entries of X where non-numeric values occur. For example, when the (1,1)th and the (2,3)th entries of a 5-by-5 matrix X are non-numeric, then the list returned by CheckNonNumeric() will contain 2, (1,1), and (2,3).
}
\description{
Check whether or not an input matrix includes any non-numeric values (NA, NULL, "", character, etc) before being used for training. If any non-numeric values exist, then TrainBuddle() or FetchBuddle() will return non-numeric results.
}
\examples{

n = 5;
p = 5;
X = matrix(0, n, p)       #### Generate a 5-by-5 matrix which includes two NA's. 
X[1,1] = NA
X[2,3] = NA

lst = CheckNonNumeric(X)

lst

}
\seealso{
GetPrecision(), FetchBuddle(), MakeConfusionMatrix(), OneHot2Label(), Split2TrainTest(), TrainBuddle()
}
