% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normexp.R
\name{pnormweibull}
\alias{pnormweibull}
\title{Cumulative Distribution Function of a Gaussian Variable Plus an Weibull Variable}
\usage{
pnormweibull(q, scale, shape, rho)
}
\description{
Cumulative Distribution Function of a Gaussian Variable Plus an Weibull Variable
}
\examples{
\dontrun{
n <- 1e6

pnormweibull(0.1, scale = 1/2, shape = 1, rho = 1.5)
pnormweibull(0.8, scale = 1/2, shape = 1, rho = 1.5)
mean(rnorm(n) + 1.5 * rweibull(n, scale = 1/2, shape = 1) <= 0.1)
mean(rnorm(n) + 1.5 * rweibull(n, scale = 1/2, shape = 1) <= 0.8)

pnormweibull(0.1, scale = 1/2, shape = 1, rho = -1.5)
pnormweibull(0.8, scale = 1/2, shape = 1, rho = -1.5)
mean(rnorm(n) - 1.5 * rweibull(n, scale = 1/2, shape = 1) <= 0.1)
mean(rnorm(n) - 1.5 * rweibull(n, scale = 1/2, shape = 1) <= 0.8)

pnormweibull(0.1, scale = 1/2, shape = 2, rho = -1.5)
pnormweibull(0.8, scale = 1/2, shape = 2, rho = -1.5)
mean(rnorm(n) - 1.5 * rweibull(n, scale = 1/2, shape = 2) <= 0.1)
mean(rnorm(n) - 1.5 * rweibull(n, scale = 1/2, shape = 2) <= 0.8)
}
}
\keyword{internal}
