% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuyseTest-Peron.R,
%   R/BuyseTest-initialization.R, R/BuyseTest.R
\name{calcPeron}
\alias{calcPeron}
\alias{internal-initialization}
\alias{initializeArgs}
\alias{initializeData}
\alias{initializeFormula}
\alias{calcSample}
\title{internal functions for BuyseTest - initialization}
\usage{
calcPeron(
  data,
  model.tte,
  fitter,
  args,
  method.score,
  treatment,
  level.treatment,
  endpoint,
  endpoint.TTE,
  endpoint.UTTE,
  status,
  status.TTE,
  status.UTTE,
  D.TTE,
  D.UTTE,
  level.strata,
  n.strata,
  strata,
  threshold,
  restriction,
  precompute,
  iidNuisance,
  out
)

initializeArgs(
  status,
  correction.uninf = NULL,
  cpus = NULL,
  data,
  endpoint,
  formula,
  hierarchical = NULL,
  keep.pairScore = NULL,
  method.inference = NULL,
  scoring.rule = NULL,
  pool.strata = NULL,
  model.tte,
  n.resampling = NULL,
  strata.resampling = NULL,
  name.call,
  neutral.as.uninf = NULL,
  add.halfNeutral = NULL,
  operator = NULL,
  censoring,
  restriction,
  option,
  seed = NULL,
  strata,
  threshold,
  trace = NULL,
  treatment,
  type,
  weightEndpoint = NULL,
  weightObs = NULL,
  envir
)

initializeData(
  data,
  type,
  endpoint,
  Uendpoint,
  D,
  scoring.rule,
  status,
  Ustatus,
  method.inference,
  censoring,
  strata,
  treatment,
  hierarchical,
  copy,
  keep.pairScore,
  endpoint.TTE,
  status.TTE,
  iidNuisance,
  weightEndpoint,
  weightObs
)

initializeFormula(x, hierarchical, envir)

calcSample(envir, method.inference)
}
\description{
Functions called by \code{\link{BuyseTest}} to initialize the arguments.
}
\details{
\code{initializeArgs}: Normalize the argument 
\itemize{
\item scoring.rule, pool.strata, neutral.as.uninf, add.halfNeutral, keep.pairScore, n.resampling, seed, cpus, trace: set to default value when not specified.
\item formula: call \code{initializeFormula} to extract arguments.
\item type: convert to numeric.
\item status: only keep status relative to TTE endpoint. Set to \code{NULL} if no TTE endpoint.
\item threshold: set default threshold to 1e-12.
the rational being we consider a pair favorable if X>Y ie X>=Y+1e-12.
When using a threshold e.g. 5 we want X>=Y+5 and not X>Y+5, especially when the measurement is discrete. \cr
\item data: convert to data.table object.
\item scoring.rule: convert to numeric.
}

\code{initializeFormula}:  extract \code{treatment}, \code{type}, \code{endpoint}, \code{threshold}, \code{status}, \code{operator}, and \code{strata}
from the formula. \cr \cr

\code{initializeData}: Divide the dataset into two, one relative to the treatment group and the other relative to the control group.
Merge the strata into one with the interaction variable.
Extract for each strata the index of the observations within each group.
}
\author{
Brice Ozenne
}
\keyword{BuyseTest}
\keyword{function}
\keyword{internal}
