% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterMethods.R
\name{plot.clusterforest}
\alias{plot.clusterforest}
\title{Plot a clusterforest object}
\usage{
\method{plot}{clusterforest}(x, ..., solution = NULL)
}
\arguments{
\item{x}{A clusterforest object}

\item{...}{Additional arguments}

\item{solution}{The solution to plot the medoid trees from. Default = NULL}
}
\description{
A function that can be used to plot a clusterforest object, either by returning plots
with information on the cluster solutions (e.g., average silhouette width), or plots of the medoid trees of each solution.
}
\details{
This function can be used to plot a clusterforest object in two ways. If it's used with as only argument
the clusterforest object, then the average silhouette width, agreement in predicted labels between medoids in solution and forest,
and within cluster similarity measures are plotted for each solution.
These plots may be helpful in deciding how many clusters are needed to summarize the forest (see Sies & Van Mechelen, 2020).

If the function is used with two arguments (the clusterforest object and the number of the solution), then the medoid tree(s)
of that solution are plotted.
}
\examples{
require(MASS)
require(rpart)
#Function to draw a bootstrap sample from a dataset
DrawBoots <- function(dataset, i){
set.seed(2394 + i)
Boot <- dataset[sample(1:nrow(dataset), size = nrow(dataset), replace = TRUE),]
return(Boot)
}

#Function to grow a tree using rpart on a dataset
GrowTree <- function(x,y,BootsSample, minsplit = 40, minbucket = 20, maxdepth =3){
 controlrpart <- rpart.control(minsplit = minsplit, minbucket = minbucket,
 maxdepth = maxdepth, maxsurrogate = 0, maxcompete = 0)
 tree <- rpart(as.formula(paste(noquote(paste(y, "~")),
 noquote(paste(x, collapse="+")))), data = BootsSample,
 control = controlrpart)
 return(tree)
}

#Use functions to draw 20 boostrapsamples and grow a tree on each sample
Boots<- lapply(1:10, function(k) DrawBoots(Pima.tr ,k))
Trees <- lapply(1:10, function (i) GrowTree(x=c("npreg", "glu",  "bp",
 "skin",  "bmi", "ped", "age"), y="type",
Boots[[i]] ))

ClusterForest<- clusterforest(fulldata=Pima.tr,treedata=Boots,trees=Trees,m=1,
fromclus=1, toclus=5)
plot(ClusterForest)
plot(ClusterForest,2)
}
\references{
\cite{Sies, A. & Van Mechelen I. (2020). C443: An R-package to see a forest for the trees. Journal of Classification.}
}
