% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/churn.R
\docType{data}
\name{churn}
\alias{churn}
\alias{churnTrain}
\alias{churnTest}
\title{Customer Churn Data}
\source{
\url{http://www.sgi.com/tech/mlc/},
\url{http://www.rulequest.com/see5-examples.html}
}
\value{
\item{churnTrain}{The training set} \item{churnTest}{The test set.}
}
\description{
A data set from the MLC++ machine learning software for modeling customer
churn. There are 19 predictors, mostly numeric: \code{state} (categorical),
\code{account_length} \code{area_code} \code{international_plan} (yes/no),
\code{voice_mail_plan} (yes/no), \code{number_vmail_messages}
\code{total_day_minutes} \code{total_day_calls} \code{total_day_charge}
\code{total_eve_minutes} \code{total_eve_calls} \code{total_eve_charge}
\code{total_night_minutes} \code{total_night_calls}
\code{total_night_charge} \code{total_intl_minutes}
\code{total_intl_calls} \code{total_intl_charge}, and
\code{number_customer_service_calls}.
}
\details{
The outcome is contained in a column called \code{churn} (also yes/no).

The training data has 3333 samples and the test set contains 1667.

A note in one of the source files states that the data are "artificial based
on claims similar to real world".

A rule-based model shown on the RuleQuest website contains 19 rules,
including:
\preformatted{ 
Rule 1: (60, lift 6.8)
         international_plan = yes
         total_intl_calls <= 2
         ->  class yes  [0.984]

Rule 5: (43/2, lift 6.4)
        international_plan = no
        voice_mail_plan = no
        total_day_minutes > 246.6
        total_eve_charge > 20.5
        ->  class yes  [0.933]

Rule 10: (211/84, lift 4.1)
         total_day_minutes > 264.4
          ->  class yes  [0.601]
}
}
\keyword{datasets}
