/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.neptuneinc.cadstat.prefs.PreferencesManager;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;

public class ConditionalProbability
extends DataPlotDialog {
    private String condDir;
    private String probDir;
    private JLabel alphaLabel;
    private JSpinner alphaSpinner;
    private JPanel analysisOptionsPane;
    private JCheckBox bootstrapCheckBox;
    private JCheckBox browserResults;
    private ButtonGroup condDirButtonGroup;
    private JRadioButton condDirGreaterThanRadioButton;
    private JLabel condDirLabel;
    private JRadioButton condDirLessThanRadioButton;
    private JLabel condValueLabel;
    private JSpinner condValueSpinner;
    private JLabel numBootstrapsLabel;
    private JSpinner numBootstrapsSpinner;
    private JPanel plotLabelPane;
    private JPanel plotPane;
    private JTextField plotTitle;
    private JLabel plotTitleLabel;
    private ButtonGroup probDirButtonGroup;
    private JRadioButton probDirGreaterThanEqualRadioButton;
    private JLabel probDirLabel;
    private JRadioButton probDirLessThanEqualRadioButton;
    private JComboBox responseComboBox;
    private JLabel responseLabel;
    private JPanel savePanel;
    private JComboBox stressorComboBox;
    private JLabel stressorLabel;
    private JPanel varPane;
    private JCheckBox weightsCheckBox;
    private JComboBox weightsComboBox;
    private JLabel weightsLabel;
    private JTextField xAxis;
    private JLabel xAxisLabel;
    private JTextField yAxis;
    private JLabel yAxisLabel;

    protected void initCustom() {
        this.initComponents();
        this.getPlotPane().add((Component)this.plotPane, "Center");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConditionalProbability.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.refreshVariableList();
        this.refreshCondValue();
        this.refreshValidity();
        this.refreshyAxis();
    }

    private void datasetComboBoxActionPerformed(ActionEvent e) {
        this.refreshVariableList();
        this.refreshCondValue();
        this.refreshValidity();
        this.refreshyAxis();
    }

    public void refreshVariableListValidity() {
        this.stressorLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.stressorComboBox.getItemCount() > 0);
        this.stressorComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.stressorComboBox.getItemCount() > 0);
        this.responseLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.responseComboBox.getItemCount() > 0);
        this.responseComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.responseComboBox.getItemCount() > 0);
        this.weightsLabel.setEnabled(this.weightsCheckBox.isSelected());
        this.weightsComboBox.setEnabled(this.weightsCheckBox.isSelected());
    }

    public void refreshVariableList() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            Vector nonFactors = RUtils.nonFactors(this.getDatasetPane().getSelectedDataset());
            this.stressorComboBox.setModel(new DefaultComboBoxModel(nonFactors));
            this.responseComboBox.setModel(new DefaultComboBoxModel(nonFactors));
            this.weightsComboBox.setModel(new DefaultComboBoxModel(nonFactors));
            if (this.stressorComboBox.getItemCount() > 0) {
                this.stressorComboBox.setSelectedIndex(0);
            }
            if (this.responseComboBox.getItemCount() > 0) {
                this.responseComboBox.setSelectedIndex(0);
            }
            if (this.weightsComboBox.getItemCount() > 0) {
                this.weightsComboBox.setSelectedIndex(0);
            }
        } else {
            this.stressorComboBox.removeAllItems();
            this.responseComboBox.removeAllItems();
            this.weightsComboBox.removeAllItems();
        }
        this.refreshValidity();
    }

    public void refreshCondValue() {
        if (this.responseComboBox.getItemCount() > 0) {
            SpinnerNumberModel model;
            String var = this.getDatasetPane().getSelectedDataset() + "$" + GUIUtils.getSelectedItem(this.responseComboBox);
            String rangeCmd = "range(" + var + ", na.rm=T, finite=T)";
            String meanCmd = "mean(" + var + ", na.rm=T, finite=T)";
            Vector range = RUtils.evalAsVector(rangeCmd);
            Vector mean = RUtils.evalAsVector(meanCmd);
            boolean isDouble = range.get(0) instanceof Double;
            boolean isInteger = range.get(0) instanceof Integer;
            if (isDouble) {
                double min = (Double)range.get(0);
                double max = (Double)range.get(1);
                double def = mean.get(0) instanceof Double ? Math.rint((Double)mean.get(0)) : (mean.get(0) instanceof Integer ? Math.rint(((Integer)mean.get(0)).intValue()) : Math.rint(max - 1.0));
                double step = new Double((max - min) / 100.0).intValue();
                step = step != 0.0 ? step : 1.0;
                model = new SpinnerNumberModel(def, min, max, step);
            } else if (isInteger) {
                int min = (Integer)range.get(0);
                int max = (Integer)range.get(1);
                int def = mean.get(0) instanceof Double ? ((Double)mean.get(0)).intValue() : (mean.get(0) instanceof Integer ? (Integer)mean.get(0) : max);
                int step = new Double((double)(max - min) / 100.0).intValue();
                step = step != 0 ? step : 1;
                model = new SpinnerNumberModel(def, min, max, step);
            } else {
                model = new SpinnerNumberModel(0, 0, 0, 0);
            }
            this.condValueSpinner.setModel(model);
        }
    }

    public void refreshOptionalParamsValidity() {
        this.numBootstrapsLabel.setEnabled(this.bootstrapCheckBox.isSelected());
        this.numBootstrapsSpinner.setEnabled(this.bootstrapCheckBox.isSelected());
    }

    public void refreshyAxis() {
        this.yAxis.setText(GUIUtils.getSelectedItem(this.responseComboBox));
    }

    public void refreshxAxis() {
        this.xAxis.setText(GUIUtils.getSelectedItem(this.stressorComboBox));
    }

    public void refreshSubmitButtonValidity() {
        this.getSubmitButton().setEnabled(this.responseComboBox.getItemCount() > 0);
    }

    public void refreshValidity() {
        this.refreshVariableListValidity();
        this.refreshOptionalParamsValidity();
        this.refreshSubmitButtonValidity();
    }

    private void initComponents() {
        this.plotPane = new JPanel();
        this.varPane = new JPanel();
        this.stressorLabel = new JLabel();
        this.stressorComboBox = new JComboBox();
        this.responseLabel = new JLabel();
        this.responseComboBox = new JComboBox();
        this.weightsLabel = new JLabel();
        this.weightsComboBox = new JComboBox();
        this.weightsCheckBox = new JCheckBox();
        this.analysisOptionsPane = new JPanel();
        this.condDirLabel = new JLabel();
        this.condDirGreaterThanRadioButton = new JRadioButton();
        this.condDirLessThanRadioButton = new JRadioButton();
        this.condValueLabel = new JLabel();
        this.condValueSpinner = new JSpinner();
        this.probDirLabel = new JLabel();
        this.probDirGreaterThanEqualRadioButton = new JRadioButton();
        this.probDirLessThanEqualRadioButton = new JRadioButton();
        this.bootstrapCheckBox = new JCheckBox();
        this.alphaLabel = new JLabel();
        this.alphaSpinner = new JSpinner();
        this.numBootstrapsLabel = new JLabel();
        this.numBootstrapsSpinner = new JSpinner();
        this.plotLabelPane = new JPanel();
        this.plotTitleLabel = new JLabel();
        this.plotTitle = new JTextField();
        this.xAxisLabel = new JLabel();
        this.xAxis = new JTextField();
        this.yAxisLabel = new JLabel();
        this.yAxis = new JTextField();
        this.savePanel = new JPanel();
        this.browserResults = new JCheckBox();
        this.condDirButtonGroup = new ButtonGroup();
        this.probDirButtonGroup = new ButtonGroup();
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.stressorLabel.setText("Stressor:");
        this.stressorComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.stressorComboBoxActionPerformed(evt);
            }
        });
        this.responseLabel.setText("Response:");
        this.responseComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.responseComboBoxActionPerformed(evt);
            }
        });
        this.weightsLabel.setText("Weights:");
        this.weightsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.weightsComboBoxActionPerformed(evt);
            }
        });
        this.weightsCheckBox.setText("Specify a weighting variable");
        this.weightsCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ConditionalProbability.this.weightsCheckBoxStateChanged(evt);
            }
        });
        GroupLayout varPaneLayout = new GroupLayout((Container)this.varPane);
        this.varPane.setLayout((LayoutManager)varPaneLayout);
        varPaneLayout.setHorizontalGroup((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((GroupLayout.Group)varPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((GroupLayout.Group)varPaneLayout.createSequentialGroup().add(6, 6, 6).add((Component)this.weightsLabel).addPreferredGap(0).add((Component)this.weightsComboBox, 0, 163, Short.MAX_VALUE)).add((GroupLayout.Group)varPaneLayout.createSequentialGroup().add((GroupLayout.Group)varPaneLayout.createParallelGroup(2).add((Component)this.stressorLabel).add((Component)this.responseLabel)).addPreferredGap(0).add((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((Component)this.stressorComboBox, 0, 161, Short.MAX_VALUE).add((Component)this.responseComboBox, 0, 161, Short.MAX_VALUE))).add((Component)this.weightsCheckBox)).addContainerGap()));
        varPaneLayout.setVerticalGroup((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((GroupLayout.Group)varPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)varPaneLayout.createParallelGroup(3).add((Component)this.stressorLabel).add((Component)this.stressorComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)varPaneLayout.createParallelGroup(3).add((Component)this.responseLabel).add((Component)this.responseComboBox, -2, -1, -2)).add(18, 18, 18).add((Component)this.weightsCheckBox).add(7, 7, 7).add((GroupLayout.Group)varPaneLayout.createParallelGroup(3).add((Component)this.weightsLabel).add((Component)this.weightsComboBox, -2, -1, -2)).addContainerGap()));
        this.analysisOptionsPane.setBorder(BorderFactory.createTitledBorder("Analysis Options"));
        this.condDirLabel.setText("Cutoff Value Direction:");
        this.condDirButtonGroup.add(this.condDirGreaterThanRadioButton);
        this.condDirGreaterThanRadioButton.setText("Greater Than");
        this.condDirGreaterThanRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.condDirGreaterThanRadioButtonActionPerformed(evt);
            }
        });
        this.condDirButtonGroup.add(this.condDirLessThanRadioButton);
        this.condDirLessThanRadioButton.setSelected(true);
        this.condDirLessThanRadioButton.setText("Less Than");
        this.condDirLessThanRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.condDirLessThanRadioButtonActionPerformed(evt);
            }
        });
        this.condValueLabel.setLabelFor(this.condValueSpinner);
        this.condValueLabel.setText("Response Cutoff Value:");
        this.condValueSpinner.setModel(new SpinnerNumberModel((Number)0.0, null, null, (Number)0.0));
        this.probDirLabel.setText("Probability Direction:");
        this.probDirButtonGroup.add(this.probDirGreaterThanEqualRadioButton);
        this.probDirGreaterThanEqualRadioButton.setSelected(true);
        this.probDirGreaterThanEqualRadioButton.setText("Greater Than or Equal");
        this.probDirGreaterThanEqualRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.probDirGreaterThanEqualRadioButtonActionPerformed(evt);
            }
        });
        this.probDirButtonGroup.add(this.probDirLessThanEqualRadioButton);
        this.probDirLessThanEqualRadioButton.setText("Less Than or Equal");
        this.probDirLessThanEqualRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.probDirLessThanEqualRadioButtonActionPerformed(evt);
            }
        });
        this.bootstrapCheckBox.setText("Bootstrap confidence intervals");
        this.bootstrapCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ConditionalProbability.this.bootstrapCheckBoxStateChanged(evt);
            }
        });
        this.bootstrapCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConditionalProbability.this.bootstrapCheckBoxActionPerformed(evt);
            }
        });
        this.alphaLabel.setText("Confidence Interval Alpha:");
        this.alphaSpinner.setModel(new SpinnerNumberModel(0.05, 0.01, 1.0, 0.01));
        this.numBootstrapsLabel.setText("Number of Bootstraps:");
        this.numBootstrapsSpinner.setModel(new SpinnerNumberModel((Number)100, Integer.valueOf(1), null, (Number)1));
        GroupLayout analysisOptionsPaneLayout = new GroupLayout((Container)this.analysisOptionsPane);
        this.analysisOptionsPane.setLayout((LayoutManager)analysisOptionsPaneLayout);
        analysisOptionsPaneLayout.setHorizontalGroup((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().add((Component)this.probDirLabel).addPreferredGap(0).add((Component)this.probDirGreaterThanEqualRadioButton).addPreferredGap(1).add((Component)this.probDirLessThanEqualRadioButton)).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(2).add(1, (GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().add((Component)this.condValueLabel).addPreferredGap(0).add((Component)this.condValueSpinner, -2, 92, -2)).add(1, (GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().add(19, 19, 19).add((Component)this.condDirLabel).addPreferredGap(0).add((Component)this.condDirGreaterThanRadioButton))).add(42, 42, 42).add((Component)this.condDirLessThanRadioButton)).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().add((Component)this.alphaLabel).addPreferredGap(0).add((Component)this.alphaSpinner, -2, -1, -2)))).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().add(39, 39, 39).add((Component)this.numBootstrapsLabel).addPreferredGap(0).add((Component)this.numBootstrapsSpinner, -2, 56, -2)).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.bootstrapCheckBox))).addContainerGap(-1, Short.MAX_VALUE)));
        analysisOptionsPaneLayout.setVerticalGroup((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(3).add((Component)this.condValueLabel).add((Component)this.condValueSpinner, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(3).add((Component)this.condDirGreaterThanRadioButton).add((Component)this.condDirLessThanRadioButton).add((Component)this.condDirLabel)).addPreferredGap(0).add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(3).add((Component)this.probDirLabel).add((Component)this.probDirGreaterThanEqualRadioButton).add((Component)this.probDirLessThanEqualRadioButton)).addPreferredGap(0).add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(3).add((Component)this.alphaLabel).add((Component)this.alphaSpinner, -2, -1, -2)).addPreferredGap(1).add((Component)this.bootstrapCheckBox).add(3, 3, 3).add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(3).add((Component)this.numBootstrapsLabel).add((Component)this.numBootstrapsSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.plotLabelPane.setBorder(BorderFactory.createTitledBorder("Plot Labels"));
        this.plotTitleLabel.setLabelFor(this.plotTitle);
        this.plotTitleLabel.setText("Plot Title:");
        this.plotTitle.setColumns(12);
        this.plotTitle.setText("Conditional Probability");
        this.xAxisLabel.setLabelFor(this.xAxis);
        this.xAxisLabel.setText("X-Axis:");
        this.xAxis.setColumns(12);
        this.xAxis.setText("X");
        this.yAxisLabel.setLabelFor(this.yAxis);
        this.yAxisLabel.setText("Y-Axis:");
        this.yAxis.setColumns(12);
        this.yAxis.setText("Y");
        GroupLayout plotLabelPaneLayout = new GroupLayout((Container)this.plotLabelPane);
        this.plotLabelPane.setLayout((LayoutManager)plotLabelPaneLayout);
        plotLabelPaneLayout.setHorizontalGroup((GroupLayout.Group)plotLabelPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotLabelPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotLabelPaneLayout.createParallelGroup(2).add((Component)this.xAxisLabel).add((Component)this.yAxisLabel).add((Component)this.plotTitleLabel)).addPreferredGap(0).add((GroupLayout.Group)plotLabelPaneLayout.createParallelGroup(1).add((Component)this.plotTitle, -1, 155, Short.MAX_VALUE).add((Component)this.xAxis, -1, 155, Short.MAX_VALUE).add((Component)this.yAxis, -1, 155, Short.MAX_VALUE)).add(36, 36, 36)));
        plotLabelPaneLayout.setVerticalGroup((GroupLayout.Group)plotLabelPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotLabelPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotLabelPaneLayout.createParallelGroup(3).add((Component)this.plotTitleLabel).add((Component)this.plotTitle, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)plotLabelPaneLayout.createParallelGroup(3).add((Component)this.xAxisLabel).add((Component)this.xAxis, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)plotLabelPaneLayout.createParallelGroup(3).add((Component)this.yAxisLabel).add((Component)this.yAxis, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.savePanel.setBorder(BorderFactory.createTitledBorder("Results"));
        this.browserResults.setText("Display Results in Browser");
        this.browserResults.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.browserResults.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout savePanelLayout = new GroupLayout((Container)this.savePanel);
        this.savePanel.setLayout((LayoutManager)savePanelLayout);
        savePanelLayout.setHorizontalGroup((GroupLayout.Group)savePanelLayout.createParallelGroup(1).add((GroupLayout.Group)savePanelLayout.createSequentialGroup().addContainerGap().add((Component)this.browserResults).addContainerGap(-1, Short.MAX_VALUE)));
        savePanelLayout.setVerticalGroup((GroupLayout.Group)savePanelLayout.createParallelGroup(1).add((GroupLayout.Group)savePanelLayout.createSequentialGroup().add((Component)this.browserResults).addContainerGap(5, Short.MAX_VALUE)));
        GroupLayout plotPaneLayout = new GroupLayout((Container)this.plotPane);
        this.plotPane.setLayout((LayoutManager)plotPaneLayout);
        plotPaneLayout.setHorizontalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().add((Component)this.varPane, -2, -1, -2).add(18, 18, 18).add((Component)this.plotLabelPane, -2, -1, -2).addContainerGap()).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().add((Component)this.analysisOptionsPane, -2, -1, -2).addContainerGap()).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().add((Component)this.savePanel, -1, -1, Short.MAX_VALUE).add(420, 420, 420)))));
        plotPaneLayout.setVerticalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((Component)this.varPane, -2, -1, -2).add((Component)this.plotLabelPane, -2, -1, -2)).addPreferredGap(0).add((Component)this.analysisOptionsPane, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.savePanel, -2, 47, -2).addContainerGap()));
        this.setTitle("Conditional Probability");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 621) / 2, (screenSize.height - 586) / 2, 621, 586);
    }

    private void responseComboBoxActionPerformed(ActionEvent evt) {
        this.refreshCondValue();
        this.refreshyAxis();
    }

    private void bootstrapCheckBoxStateChanged(ChangeEvent evt) {
        this.refreshOptionalParamsValidity();
    }

    private void condDirGreaterThanRadioButtonActionPerformed(ActionEvent evt) {
        this.setConditionalValueDirection(">");
    }

    private void condDirLessThanRadioButtonActionPerformed(ActionEvent evt) {
        this.setConditionalValueDirection("<");
    }

    private void probDirGreaterThanEqualRadioButtonActionPerformed(ActionEvent evt) {
        this.setProbabilityDirection(">=");
    }

    private void probDirLessThanEqualRadioButtonActionPerformed(ActionEvent evt) {
        this.setProbabilityDirection("<=");
    }

    private void weightsComboBoxActionPerformed(ActionEvent evt) {
    }

    private void weightsCheckBoxStateChanged(ChangeEvent evt) {
        this.refreshVariableListValidity();
    }

    private void bootstrapCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void stressorComboBoxActionPerformed(ActionEvent evt) {
        this.refreshxAxis();
    }

    protected void submitButtonAction() {
        PreferencesManager prefsManager = new PreferencesManager();
        try {
            prefsManager.importPreferences();
        }
        catch (Exception ex) {
            Logger.getLogger(ConditionalProbability.class.getName()).log(Level.INFO, null, ex);
        }
        String cmd = "conditionalprob.JGR(my.data=" + this.getDatasetPane().getSelectedDataset() + ", x=" + "'" + GUIUtils.getSelectedItem(this.stressorComboBox) + "'" + ", y=" + "'" + GUIUtils.getSelectedItem(this.responseComboBox) + "'" + ", weights=" + (this.weightsCheckBox.isSelected() ? "'" + GUIUtils.getSelectedItem(this.weightsComboBox) + "'" : "NULL") + ", cond.val=" + this.condValueSpinner.getValue() + ", cond.val.direction=" + (this.getConditionalValueDirection() == null ? "'<'" : "'" + this.getConditionalValueDirection() + "'") + ", prob.direction=" + (this.getProbabilityDirection() == null ? "'>='" : "'" + this.getProbabilityDirection() + "'") + ", alpha=" + this.alphaSpinner.getValue() + ", R=" + (this.bootstrapCheckBox.isSelected() ? this.numBootstrapsSpinner.getValue() : "NULL") + ", subset1.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")") + ", subset2.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")") + ", main=" + "'" + this.plotTitle.getText() + "'" + ", xlab=" + "'" + this.xAxis.getText() + "'" + ", ylab=" + "'" + this.yAxis.getText() + "'" + ", browserResults=" + String.valueOf(this.browserResults.isSelected()).toUpperCase() + ", " + prefsManager.getCadstatPreferences().toString() + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    protected void helpButtonAction() {
        String cmd = "CADStat.help('conditionalprob.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    public String getConditionalValueDirection() {
        return this.condDir;
    }

    public void setConditionalValueDirection(String condDir) {
        this.condDir = condDir;
    }

    public String getProbabilityDirection() {
        return this.probDir;
    }

    public void setProbabilityDirection(String probDir) {
        this.probDir = probDir;
    }
}

