/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.neptuneinc.cadstat.plots.ConditionalProbability;
import org.neptuneinc.cadstat.prefs.PreferencesManager;
import org.neptuneinc.cadstat.ui.DatasetPane;
import org.neptuneinc.cadstat.ui.FactorSubsetPane;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;

public class BoxPlot
extends JDialog {
    private JRadioButton bothPlotTypeRadioButton;
    private JPanel buttonPane;
    private JButton cancelButton;
    private DatasetPane datasetPane;
    private JSeparator datasetSeparator;
    private JCheckBox enableGroupByCheckBox;
    private FactorSubsetPane factorSubsetPane;
    private JPanel groupByPane;
    private JButton helpButton;
    private JCheckBox horizontal;
    private JSeparator jSeparator1;
    private JRadioButton logPlotTypeRadioButton;
    private JPanel midPane;
    private JRadioButton originalPlotTypeRadioButton;
    private JPanel plotLabelsPane;
    private JPanel plotOptionsPane;
    private JTextField plotTitle;
    private JLabel plotTitleLabel;
    private ButtonGroup plotTypeGroup;
    private JPanel plotTypePane;
    private JComboBox resultComboBox;
    private JLabel resultLabel;
    private JCheckBox rotateXLabCheckBox;
    private JCheckBox sampleSizes;
    private JButton submitButton;
    private JPanel varPane;
    private JTextField yAxis;
    private JLabel yAxisLabel;

    public BoxPlot() {
        this.initComponents();
        this.datasetPane.getDatasetLabel().setText("Active Dataset:");
        this.datasetPane.getDatasetComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoxPlot.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.datasetPane.refreshDatasetComboBox();
        this.refreshVariableListValidity();
        this.refreshGroupByComponentValidity();
        this.refreshSubmitButtonValidity();
        this.getRootPane().setDefaultButton(this.submitButton);
    }

    private void datasetComboBoxActionPerformed(ActionEvent evt) {
        this.refreshVariableList();
        this.factorSubsetPane.setDataset(this.datasetPane.getSelectedDataset());
        this.refreshGroupByComponentValidity();
        this.refreshSubmitButtonValidity();
    }

    private void initComponents() {
        this.plotTypeGroup = new ButtonGroup();
        this.datasetPane = new DatasetPane();
        this.midPane = new JPanel();
        this.varPane = new JPanel();
        this.resultLabel = new JLabel();
        this.resultComboBox = new JComboBox();
        this.groupByPane = new JPanel();
        this.enableGroupByCheckBox = new JCheckBox();
        this.factorSubsetPane = new FactorSubsetPane();
        this.plotTypePane = new JPanel();
        this.originalPlotTypeRadioButton = new JRadioButton();
        this.logPlotTypeRadioButton = new JRadioButton();
        this.bothPlotTypeRadioButton = new JRadioButton();
        this.plotOptionsPane = new JPanel();
        this.sampleSizes = new JCheckBox();
        this.rotateXLabCheckBox = new JCheckBox();
        this.horizontal = new JCheckBox();
        this.plotLabelsPane = new JPanel();
        this.plotTitleLabel = new JLabel();
        this.plotTitle = new JTextField();
        this.yAxisLabel = new JLabel();
        this.yAxis = new JTextField();
        this.buttonPane = new JPanel();
        this.cancelButton = new JButton();
        this.submitButton = new JButton();
        this.helpButton = new JButton();
        this.datasetSeparator = new JSeparator();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("Boxplot");
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.resultLabel.setText("Result:");
        GroupLayout varPaneLayout = new GroupLayout((Container)this.varPane);
        this.varPane.setLayout((LayoutManager)varPaneLayout);
        varPaneLayout.setHorizontalGroup((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add(2, (GroupLayout.Group)varPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.resultLabel).addPreferredGap(0).add((Component)this.resultComboBox, 0, 191, Short.MAX_VALUE).addContainerGap()));
        varPaneLayout.setVerticalGroup((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((GroupLayout.Group)varPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)varPaneLayout.createParallelGroup(3).add((Component)this.resultLabel).add((Component)this.resultComboBox, -2, -1, -2)).addContainerGap(14, Short.MAX_VALUE)));
        this.groupByPane.setBorder(BorderFactory.createTitledBorder("Group By"));
        this.enableGroupByCheckBox.setText("Enable Grouping");
        this.enableGroupByCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                BoxPlot.this.enableGroupByCheckBoxStateChanged(evt);
            }
        });
        GroupLayout groupByPaneLayout = new GroupLayout((Container)this.groupByPane);
        this.groupByPane.setLayout((LayoutManager)groupByPaneLayout);
        groupByPaneLayout.setHorizontalGroup((GroupLayout.Group)groupByPaneLayout.createParallelGroup(1).add((GroupLayout.Group)groupByPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupByPaneLayout.createParallelGroup(1).add((Component)this.factorSubsetPane, -2, -1, -2).add((Component)this.enableGroupByCheckBox)).addContainerGap(25, Short.MAX_VALUE)));
        groupByPaneLayout.setVerticalGroup((GroupLayout.Group)groupByPaneLayout.createParallelGroup(1).add((GroupLayout.Group)groupByPaneLayout.createSequentialGroup().add((Component)this.enableGroupByCheckBox).addPreferredGap(0).add((Component)this.factorSubsetPane, -1, 167, Short.MAX_VALUE).addContainerGap()));
        this.plotTypePane.setBorder(BorderFactory.createTitledBorder("Plot Type"));
        this.plotTypeGroup.add(this.originalPlotTypeRadioButton);
        this.originalPlotTypeRadioButton.setText("Original");
        this.plotTypeGroup.add(this.logPlotTypeRadioButton);
        this.logPlotTypeRadioButton.setText("Log");
        this.plotTypeGroup.add(this.bothPlotTypeRadioButton);
        this.bothPlotTypeRadioButton.setSelected(true);
        this.bothPlotTypeRadioButton.setText("Both");
        GroupLayout plotTypePaneLayout = new GroupLayout((Container)this.plotTypePane);
        this.plotTypePane.setLayout((LayoutManager)plotTypePaneLayout);
        plotTypePaneLayout.setHorizontalGroup((GroupLayout.Group)plotTypePaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotTypePaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotTypePaneLayout.createParallelGroup(1).add((Component)this.originalPlotTypeRadioButton).add((Component)this.logPlotTypeRadioButton).add((Component)this.bothPlotTypeRadioButton)).addContainerGap(182, Short.MAX_VALUE)));
        plotTypePaneLayout.setVerticalGroup((GroupLayout.Group)plotTypePaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotTypePaneLayout.createSequentialGroup().add((Component)this.originalPlotTypeRadioButton).addPreferredGap(0).add((Component)this.logPlotTypeRadioButton).addPreferredGap(0).add((Component)this.bothPlotTypeRadioButton).addContainerGap(10, Short.MAX_VALUE)));
        this.plotOptionsPane.setBorder(BorderFactory.createTitledBorder("Plot Options"));
        this.sampleSizes.setText("Sample Sizes");
        this.rotateXLabCheckBox.setText("Rotate X-Axis Labels");
        this.horizontal.setText("Horizontal Boxplot");
        this.horizontal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPlot.this.horizontalActionPerformed(evt);
            }
        });
        GroupLayout plotOptionsPaneLayout = new GroupLayout((Container)this.plotOptionsPane);
        this.plotOptionsPane.setLayout((LayoutManager)plotOptionsPaneLayout);
        plotOptionsPaneLayout.setHorizontalGroup((GroupLayout.Group)plotOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotOptionsPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotOptionsPaneLayout.createParallelGroup(1).add((Component)this.sampleSizes).add((Component)this.rotateXLabCheckBox).add((Component)this.horizontal)).addContainerGap(118, Short.MAX_VALUE)));
        plotOptionsPaneLayout.setVerticalGroup((GroupLayout.Group)plotOptionsPaneLayout.createParallelGroup(1).add(2, (GroupLayout.Group)plotOptionsPaneLayout.createSequentialGroup().add((Component)this.horizontal).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.sampleSizes).addPreferredGap(0).add((Component)this.rotateXLabCheckBox).addContainerGap()));
        this.plotLabelsPane.setBorder(BorderFactory.createTitledBorder("Plot Labels"));
        this.plotTitleLabel.setHorizontalAlignment(4);
        this.plotTitleLabel.setLabelFor(this.plotTitle);
        this.plotTitleLabel.setText("Plot Title");
        this.plotTitle.setColumns(10);
        this.plotTitle.setText("Boxplot");
        this.yAxisLabel.setHorizontalAlignment(4);
        this.yAxisLabel.setLabelFor(this.yAxis);
        this.yAxisLabel.setText("Result-Axis");
        this.yAxis.setColumns(10);
        this.yAxis.setText("Y");
        GroupLayout plotLabelsPaneLayout = new GroupLayout((Container)this.plotLabelsPane);
        this.plotLabelsPane.setLayout((LayoutManager)plotLabelsPaneLayout);
        plotLabelsPaneLayout.setHorizontalGroup((GroupLayout.Group)plotLabelsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotLabelsPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotLabelsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotLabelsPaneLayout.createSequentialGroup().add((Component)this.plotTitleLabel).addPreferredGap(0).add((Component)this.plotTitle, -1, 171, Short.MAX_VALUE)).add((GroupLayout.Group)plotLabelsPaneLayout.createSequentialGroup().add((Component)this.yAxisLabel).addPreferredGap(0).add((Component)this.yAxis, -1, 171, Short.MAX_VALUE))).addContainerGap()));
        plotLabelsPaneLayout.linkSize(new Component[]{this.plotTitleLabel, this.yAxisLabel}, 1);
        plotLabelsPaneLayout.setVerticalGroup((GroupLayout.Group)plotLabelsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotLabelsPaneLayout.createSequentialGroup().add((GroupLayout.Group)plotLabelsPaneLayout.createParallelGroup(3).add((Component)this.plotTitleLabel).add((Component)this.plotTitle, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)plotLabelsPaneLayout.createParallelGroup(3).add((Component)this.yAxisLabel).add((Component)this.yAxis, -2, -1, -2)).addContainerGap(14, Short.MAX_VALUE)));
        GroupLayout midPaneLayout = new GroupLayout((Container)this.midPane);
        this.midPane.setLayout((LayoutManager)midPaneLayout);
        midPaneLayout.setHorizontalGroup((GroupLayout.Group)midPaneLayout.createParallelGroup(1).add((GroupLayout.Group)midPaneLayout.createSequentialGroup().add((GroupLayout.Group)midPaneLayout.createParallelGroup(1).add((Component)this.groupByPane, -1, -1, Short.MAX_VALUE).add((Component)this.varPane, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)midPaneLayout.createParallelGroup(1).add((Component)this.plotTypePane, -1, -1, Short.MAX_VALUE).add((Component)this.plotLabelsPane, -2, -1, -2).add((Component)this.plotOptionsPane, -2, -1, -2)).addContainerGap()));
        midPaneLayout.linkSize(new Component[]{this.groupByPane, this.plotLabelsPane, this.plotOptionsPane, this.plotTypePane, this.varPane}, 1);
        midPaneLayout.setVerticalGroup((GroupLayout.Group)midPaneLayout.createParallelGroup(1).add((GroupLayout.Group)midPaneLayout.createSequentialGroup().add((GroupLayout.Group)midPaneLayout.createParallelGroup(1).add((GroupLayout.Group)midPaneLayout.createSequentialGroup().add((Component)this.varPane, -2, -1, -2).addPreferredGap(0).add((Component)this.groupByPane, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)midPaneLayout.createSequentialGroup().add((Component)this.plotTypePane, -2, -1, -2).addPreferredGap(0).add((Component)this.plotOptionsPane, -2, -1, -2).addPreferredGap(0).add((Component)this.plotLabelsPane, -2, -1, -2))).addContainerGap()));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPlot.this.cancelButtonActionPerformed(evt);
            }
        });
        this.submitButton.setText("Submit");
        this.submitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPlot.this.submitButtonActionPerformed(evt);
            }
        });
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxPlot.this.helpButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonPaneLayout = new GroupLayout((Container)this.buttonPane);
        this.buttonPane.setLayout((LayoutManager)buttonPaneLayout);
        buttonPaneLayout.setHorizontalGroup((GroupLayout.Group)buttonPaneLayout.createParallelGroup(1).add((GroupLayout.Group)buttonPaneLayout.createSequentialGroup().add(160, 160, 160).add((Component)this.cancelButton).addPreferredGap(0).add((Component)this.submitButton).addPreferredGap(0).add((Component)this.helpButton).addContainerGap(193, Short.MAX_VALUE)));
        buttonPaneLayout.setVerticalGroup((GroupLayout.Group)buttonPaneLayout.createParallelGroup(1).add((GroupLayout.Group)buttonPaneLayout.createSequentialGroup().add((GroupLayout.Group)buttonPaneLayout.createParallelGroup(3).add((Component)this.cancelButton).add((Component)this.submitButton).add((Component)this.helpButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.datasetSeparator, -1, 578, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(111, 111, 111).add((Component)this.datasetPane, -2, -1, -2).addContainerGap(160, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.midPane, -2, -1, -2).addContainerGap(30, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jSeparator1, -1, 558, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.buttonPane, -1, -1, Short.MAX_VALUE).add(20, 20, 20)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.datasetPane, -2, -1, -2).addPreferredGap(0).add((Component)this.datasetSeparator, -2, 10, -2).addPreferredGap(0).add((Component)this.midPane, -1, 312, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.buttonPane, -2, -1, -2).add(12, 12, 12)));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        PreferencesManager prefsManager = new PreferencesManager();
        try {
            prefsManager.importPreferences();
        }
        catch (Exception ex) {
            Logger.getLogger(ConditionalProbability.class.getName()).log(Level.INFO, null, ex);
        }
        String plotType = "both";
        if (this.originalPlotTypeRadioButton.isSelected()) {
            plotType = "original";
        } else if (this.logPlotTypeRadioButton.isSelected()) {
            plotType = "log";
        } else if (this.bothPlotTypeRadioButton.isSelected()) {
            plotType = "both";
        }
        String cmd = "boxplot.JGR(x=" + this.datasetPane.getSelectedDataset() + ", result=" + "'" + GUIUtils.getSelectedItem(this.resultComboBox) + "'" + ", group.name=" + (this.enableGroupByCheckBox.isSelected() ? "'" + this.factorSubsetPane.getSelectedFactor() + "'" : "NULL") + ", group.val=" + "c(" + RUtils.toString(this.factorSubsetPane.getSelectedFactorValues(), ",", "'") + ")" + ", subset1.name=" + "NULL" + ", subset1.val=" + "NULL" + ", subset2.name=" + "NULL" + ", subset2.val=" + "NULL" + ", main=" + "'" + this.plotTitle.getText() + "'" + ", result.lab=" + "'" + this.yAxis.getText() + "'" + ", plot.type=" + "'" + plotType + "'" + ", horizontal=" + String.valueOf(this.horizontal.isSelected()).toUpperCase() + ", iSampleSize=" + String.valueOf(this.sampleSizes.isSelected()).toUpperCase() + ", names.rot=" + String.valueOf(this.rotateXLabCheckBox.isSelected()).toUpperCase() + ", " + prefsManager.getCadstatPreferences().toString() + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        String cmd = "CADStat.help('boxplot.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    private void enableGroupByCheckBoxStateChanged(ChangeEvent evt) {
        this.refreshGroupByComponentValidity();
        this.refreshSubmitButtonValidity();
    }

    private void horizontalActionPerformed(ActionEvent evt) {
        this.refreshSampleSizes();
    }

    public void refreshVariableListValidity() {
        this.resultComboBox.setEnabled(this.datasetPane.getDatasetComboBox().getItemCount() > 0 && this.resultComboBox.getItemCount() > 0);
    }

    public void refreshSampleSizes() {
        this.sampleSizes.setSelected(!this.horizontal.isSelected() && this.sampleSizes.isSelected());
        this.sampleSizes.setEnabled(!this.horizontal.isSelected());
    }

    public void refreshVariableList() {
        if (this.datasetPane.getDatasetComboBox().getItemCount() > 0) {
            Vector nonFactors = RUtils.nonFactors(this.datasetPane.getSelectedDataset());
            this.resultComboBox.setModel(new DefaultComboBoxModel(nonFactors));
            if (this.resultComboBox.getItemCount() > 0) {
                this.resultComboBox.setSelectedIndex(0);
            }
        } else {
            this.resultComboBox.removeAllItems();
        }
        this.refreshVariableListValidity();
        this.refreshSubmitButtonValidity();
    }

    public void refreshGroupByComponentValidity() {
        JLabel factorLabel = this.factorSubsetPane.getFactorLabel();
        JComboBox factorComboBox = this.factorSubsetPane.getFactorComboBox();
        JScrollPane factorValueScrollPane = this.factorSubsetPane.getFactorValueScrollPane();
        JList factorValueList = this.factorSubsetPane.getFactorValueList();
        boolean groupByEnabled = this.enableGroupByCheckBox.isSelected();
        factorLabel.setEnabled(groupByEnabled && factorComboBox.getItemCount() > 0);
        factorComboBox.setEnabled(groupByEnabled && factorComboBox.getItemCount() > 0);
        factorValueScrollPane.setEnabled(groupByEnabled && factorValueList.getModel().getSize() > 0);
        factorValueList.setEnabled(groupByEnabled && factorValueList.getModel().getSize() > 0);
    }

    public void refreshSubmitButtonValidity() {
        JComboBox factorComboBox = this.factorSubsetPane.getFactorComboBox();
        this.submitButton.setEnabled(this.datasetPane.getDatasetComboBox().getItemCount() > 0 && this.resultComboBox.getItemCount() > 0 && (!this.enableGroupByCheckBox.isSelected() || factorComboBox.getItemCount() > 0));
    }
}

