% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caesar.R
\name{CAESAR.coembedding}
\alias{CAESAR.coembedding}
\title{Compute Co-embedding Using CAESAR}
\usage{
CAESAR.coembedding(
  seu,
  pos,
  reduction.name = "caesar",
  q = 50,
  radius.upper = 400,
  ...
)
}
\arguments{
\item{seu}{A Seurat object containing spatial transcriptomics data.}

\item{pos}{A matrix of spatial coordinates for the spots (e.g., spatial positions of cells or pixels in the image). The row names of `pos` should match the column names of `seu`.}

\item{reduction.name}{A character string specifying the name of the dimensional reduction method to store in the Seurat object. Default is "caesar".}

\item{q}{An integer specifying the number of dimensions for the reduced co-embeddings. Default is 50.}

\item{radius.upper}{A numeric value specifying the upper limit of the search radius for the spatial adjacency matrix. Default is 400.}

\item{...}{Additional arguments passed to `cellembedding_image_seurat`.}
}
\value{
The modified Seurat object with the computed cell and gene embeddings stored in the specified reduction slot.
}
\description{
This function performs co-embedding of both cells and genes using the CAESAR method. It integrates spatial transcriptomics data from a Seurat object (`seu`) with a spatial adjacency matrix to compute the low-dimensional co-embedding.
}
\examples{
data(toydata)

seu <- toydata$seu
pos <- toydata$pos

seu <- CAESAR.coembedding(
    seu = seu,
    pos = pos
)
print(seu)
}
\seealso{
\code{\link{cellembedding_seurat}} for computing cell embeddings.
\code{\link{add.gene.embedding}} for adding gene embeddings to a Seurat object.
}
