% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_se.R
\name{calc_se}
\alias{calc_se}
\title{Calculates the standard error for simple and percent differences}
\usage{
calc_se(x1, x2, dif, method = "param", boot.R = 999)
}
\arguments{
\item{x1}{vector of observations}

\item{x2}{vector of observations}

\item{dif}{name of the difference for which the SE is desired. Accepts "perc"
(for percent differences) or "simple" (for simple differences)}

\item{method}{method used to calculate the interval. Accepts "param"
(using parametric formulas based on normality of the sampling
distribution of the means) or "boot" (for bootstrap).}

\item{boot.R}{(optional) number of bootstrap resamples.}
}
\value{
a list object containing the following items:
\itemize{
\item \code{x.est} - estimated value
\item \code{se} - standard error
}
}
\description{
Calculates the sample standard error for the estimator differences between
two algorithms on a given instance.
}
\details{
\itemize{
\item If \code{dif == "perc"} it returns the SE for sample estimator of
\eqn{(mu2 - mu1) / mu1}, where \eqn{mu1, mu2} are the means of the
populations that generated the sample vectors \eqn{x1, x2}.
\item If \code{dif == "simple"} it returns the SE for sample estimator of
\eqn{(mu2 - mu1)}
}
}
\section{References}{

\itemize{
\item F. Campelo, F. Takahashi:
Sample size estimation for power and accuracy in the experimental
comparison of algorithms (submitted, 2017).
}
}

\examples{
# two vectors of normally distributed observations
set.seed(1234)
x1 <- rnorm(100, 5, 1)  # mean = 5, sd = 1
x2 <- rnorm(200, 10, 2) # mean = 10, sd = 2

# Theoretical SE for simple difference: 0.1732051
calc_se(x1, x2, dif = "simple", method = "param")

# Theoretical (Fieller, no covariance) SE for percent differences: 0.04
calc_se(x1, x2, dif = "perc", method = "boot")
}
\author{
Felipe Campelo (\email{fcampelo@ufmg.br}),
Fernanda Takahashi (\email{fernandact@ufmg.br})
}
