% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_data_files.R
\name{retrieve_data_files}
\alias{retrieve_data_files}
\title{Retrieve data files from the Github repository}
\usage{
retrieve_data_files(
  target.dir,
  method = "auto",
  unzip = getOption("unzip"),
  url = "https://github.com/fcampelo/CALANGO/raw/master/inst/extdata/Examples.zip"
)
}
\arguments{
\item{target.dir}{path to the folder where the files will be saved (
accepts relative and absolute paths)}

\item{method}{Method to be used for downloading files. Current download
methods are "internal", "wininet" (Windows only) "libcurl", "wget" and
"curl", and there is a value "auto": see _Details_ and _Note_ in the
documentation of \code{utils::download.file()}.}

\item{unzip}{The unzip method to be used. See the documentation of
\code{utils::unzip()} for details.}

\item{url}{example URL. **Do not change** unless you really know what
you're doing.}
}
\value{
No return value, called for side effects (see Description).
}
\description{
This script downloads relevant data files from the CALANGO project
repository. It will extract the data into a folder containing
directories related to dictionary files, Gene Ontology annotation
files, tree files, etc. Note: you may need to edit the file paths in the 
example scripts contained under the `parameters` subfolder of `target.dir`, 
or pass an appropriate base path using parameter `basedir` in [run_CALANGO()].
}
\details{
If the `target.dir` provided does not exist it is created
(recursively) by the function.
}
\examples{
\dontrun{
  CALANGO::retrieve_data_files(target.dir = "./data")
}

}
