% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrot_functions.R
\name{get_indices}
\alias{get_indices}
\title{Best regression}
\usage{
get_indices(predsp,nvar,c,we,st,minx)
}
\arguments{
\item{predsp}{An M x N matrix of averaged out predictive power values. M is maximum feasible number of variables included in a regression, N is the maximum feasible number of regressions of the fixed size; the row index indicates the number of variables included in a regression.}

\item{nvar}{array of maximal number of variables for each cross-validation}

\item{c}{array of all indices of the prediction variables}

\item{we}{array of all weights of the prediction variables}

\item{st}{a subset of predictors to be always included into a predictive model}

\item{minx}{minimum number of predictors, defaults to 1}
}
\value{
A list of arrays which contain indices of the predictors corresponfing to the best regressions
}
\description{
Function which identifies regressions with the highest predictive power
}
\examples{
#creating a set of averaged out predictive powers

predsp<-matrix(NA,ncol=3,nrow=3)

predsp[1,]=runif(3,0.7,0.8)
predsp[2,]=runif(3,0.65,0.85)
predsp[3,1]=runif(1,0.4,0.5)

#running the function

get_indices(predsp,c(3,3,3),1:3,c(1,1,1))
}
\seealso{
Uses \code{\link{sum_weights_sub}}, \code{\link{find_sub}}, \code{\link[utils]{combn}}
}
