% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustered_sample.R
\name{clustered_sample}
\alias{clustered_sample}
\title{Clustered samples simulation}
\usage{
clustered_sample(sarea, nsamples, nparents, radius)
}
\arguments{
\item{sarea}{polygon. Area where samples should be simulated.}

\item{nsamples}{integer. Number of samples to be simulated.}

\item{nparents}{integer. Number of parents.}

\item{radius}{integer. Radius of the buffer around each parent for offspring simulation.}
}
\value{
sf object with the simulated points and the parent to which each point belongs to.
}
\description{
Clustered samples simulation
}
\details{
A simple procedure to simulate clustered points based on a two-step sampling.
First, a pre-specified number of parents are simulated using random sampling.
For each parent, `(nsamples-nparents)/nparents` are simulated within a radius of the parent point using random sampling.
}
\examples{
# Simulate 100 points in a 100x100 square with 5 parents and a radius of 10.
library(sf)
library(ggplot2)

set.seed(1234)
simarea <- list(matrix(c(0,0,0,100,100,100,100,0,0,0), ncol=2, byrow=TRUE))
simarea <- sf::st_polygon(simarea)
simpoints <- clustered_sample(simarea, 100, 5, 10)
simpoints$parent <- as.factor(simpoints$parent)
ggplot() +
    geom_sf(data = simarea, alpha = 0) +
    geom_sf(data = simpoints, aes(col = parent))

}
\author{
Carles Milà
}
