% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cols_corr_scatter.R
\name{cols.corr.scatter}
\alias{cols.corr.scatter}
\title{Scatterplot for column categories correlation with dimensions}
\usage{
cols.corr.scatter(data, x = 1, y = 2, cex.labls = 3)
}
\arguments{
\item{data}{Name of the dataset (must be in dataframe format).}

\item{x}{First dimension for which the correlations are reported (x=1 by default).}

\item{y}{Second dimension for which the correlations are reported (y=2 by default).}

\item{cex.labls}{Adjust the size of the categories' labels}
}
\description{
This function allows to plot a scatterplot of the correlation (sqrt(COS2)) of column categories
with two selected dimensions. A diagonal line is a visual aid to eyeball whether a category is
actually more correlated (in relative terms) to either of the two dimensions. The column
categories' labels are coupled with two + or - symbols within round brackets indicating to which
side of the two selected dimensions the correlation values that can be read off from the chart
are actually referring. The first symbol (i.e., the one to the left), either + or -, refers to
the first of the selected dimensions (i.e., the one reported on the x-axis). The second symbol
(i.e., the one to the right) refers to the second of the selected dimensions (i.e., the one
reported on the y-axis).
}
\examples{
data(greenacre_data) #load the sample dataset

#Plots the scatterplot of the column categories correlation with dimensions 1&2.
cols.corr.scatter(greenacre_data,1,2)

}
\seealso{
\code{\link{cols.corr}} , \code{\link{rows.corr}} ,
  \code{\link{rows.corr.scatter}}
}
\keyword{cols.corr.scatter}
