% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFtime.R
\name{slab}
\alias{slab}
\title{Which time steps fall within two extreme values}
\usage{
slab(x, extremes, rightmost.closed = FALSE)
}
\arguments{
\item{x}{CFtime. The time series to operate on.}

\item{extremes}{character. Vector of two timestamps that represent the
extremes of the time period of interest. The timestamps must be in
increasing order. The timestamps need not fall in the range of the time
steps in the CFtime stance.}

\item{rightmost.closed}{Is the larger extreme value included in the result?
Default is \code{FALSE}.}
}
\value{
A logical vector with a length equal to the number of time steps in
\code{x} with values \code{TRUE} for those time steps that fall between the two
extreme values, \code{FALSE} otherwise. The earlier timestamp is included, the
later timestamp is excluded. A specification of \code{c("2022-01-01", "2023-01-01")}
will thus include all time steps that fall in the year 2022.
}
\description{
Given two extreme character timestamps, return a logical vector of a length
equal to the number of time steps in the CFtime instance with values \code{TRUE}
for those time steps that fall between the two extreme values, \code{FALSE}
otherwise. This can be used to select slices from the time series in reading
or analysing data.
}
\details{
If bounds were set these will be preserved.
}
\examples{
cf <- CFtime("hours since 2023-01-01 00:00:00", "standard", 0:23)
slab(cf, c("2022-12-01", "2023-01-01 03:00"))
}
