% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterPlot.R
\name{scatterPlot}
\alias{scatterPlot}
\title{Scatterplot by a selected feature}
\usage{
scatterPlot(
  seu,
  reduction,
  colour.by,
  colvec = NULL,
  title = NULL,
  sort.by.numbers = TRUE,
  viridis_option = "B"
)
}
\arguments{
\item{seu}{Seurat S4 object after the step of `getIDER`. Required.}

\item{reduction}{Character. The dimension reduction used to plot. Common
options: "pca", "tsne", "umap". The availability of dimension reduction
can be checked by `Reductions(seu)`.}

\item{colour.by}{Character. One of the column names of `seu@meta.data`.
Can be either discreet or continuous variables.}

\item{colvec}{A vector of Hex colour codes. If no value is given (default),
a vector of 74 colours will be used.}

\item{title}{Character. Title of the figure.}

\item{sort.by.numbers}{Boolean. Whether to sort the groups by the number
of cells.(Default: True)}

\item{viridis_option}{viridis_option. (Default: B)}
}
\value{
a scatter plot
}
\description{
Scatterplot of a Seurat object based on dimension reduction.
}
