% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/create.constraints.r
\name{create.constraints}
\alias{create.constraints}
\title{Generate common order constraints}
\usage{
create.constraints(P1, constraints)
}
\arguments{
\item{P1}{the length of \eqn{\theta_1}{theta_1}, the vector constrained coefficients.}

\item{constraints}{List with the elements \code{order}, \code{node}, and \code{decreasing}. See Details for further information.}
}
\value{
The function returns a list containing the elements of input argument \code{constraints} as well as
\itemize{
\item{ \code{A} }{matrix of dimension \eqn{r \times 2}{r x 2} containing the order constraints, where r is the number of linear constraints.}
\item{ \code{B} }{matrix containing the contrasts necessary for computation of the Williams' type test statistic (may be identical to \code{A}).}
\item{ \code{Anull} }{matrix similar to \code{A} which defines all possible constraints. Used to obtain parameter estimates under the null hypothesis.}
\item{ \code{order} }{the input argument for \code{constraints\$order}.}
\item{ \code{node} }{the input argument for \code{constraints\$node}.}
\item{ \code{decreasing} }{ the input argument for \code{constraints\$decreasing}}
}
See \code{\link{w.stat}} for more information on \code{B}
}
\description{
Automatically generates the constraints in the format used by \code{\link{clme}}. Allowed orders are simple, simple tree, and umbrella orders.
}
\details{
The elements of \code{constraints} are:
\itemize{
\item \code{order}: string. Currently \dQuote{simple}, \dQuote{simple.tree} and \dQuote{umbrella} are supported.
\item \code{node}: numeric, the node of the coefficients (unnecessary for simple orders).
\item \code{decreasing}: logical. For simple orders, is the trend decreasing? For umbrella and simple tree, does the nodal parameter have the greatest value (e.g., the peak, instead of the valley)?
}

See \code{\link{clme}} for more information and a depiction of these three elements.
}
\note{
The function \code{\link{clme}} also utilizes the argument \code{constraints}. For \code{clme}, this argument may either be identical to the argument of this function, or may be the output of \code{create.constraints} (that is, a list containing appropriate matrices \code{A}, \code{Anull}, and if necessary, \code{B}).

An example the the \code{A} matrix might be:
  \tabular{ccc}{
    [1,] \tab [,1] \tab [,2] \cr
    [2,] \tab 1    \tab 2    \cr
    [3,] \tab 2    \tab 3    \cr
    [4,] \tab 4    \tab 3    \cr
    [5,] \tab 5    \tab 4    \cr
    [6,] \tab 6    \tab 5    \cr
  }
This matrix defines what \pkg{CLME} describes as a decreasing umbrella order. The first row defines the constraint that \eqn{\theta_1 \leq \theta_2}{theta_1 <= theta_2}, the second row defined the constraint \eqn{\theta_2 \leq \theta_3}{theta_2 <= theta_3}, the third row defines \eqn{\theta_4 \leq \theta_3}{theta_4 <= theta_3}, and so on. The values are indexes, and the left column is the index of the parameter constrained to be smaller.
}
\examples{
\dontrun{
  # For simple order, the node does not matter
  create.constraints( P1 = 5, constraints = list( order='simple' ,
                                                  decreasing=FALSE ))

  # Compare constraints against decreasing=TRUE
  create.constraints( P1 = 5, constraints=list( order='simple' ,
                                                decreasing=TRUE ))

  # Umbrella order
  create.constraints( P1 = 5, constraints=list( order='umbrella' , node=3
                                                , decreasing=FALSE ))
}
}
\seealso{
\code{\link{clme}},
\code{\link{w.stat}}
}

