% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pnbd_CET}
\alias{pnbd_CET}
\alias{pnbd_nocov_CET}
\alias{pnbd_staticcov_CET}
\title{Pareto/NBD: Conditional Expected Transactions}
\usage{
pnbd_nocov_CET(vEstimated_params, dPrediction_period, vX, vT_x, vT_cal)

pnbd_staticcov_CET(
  vEstimated_params,
  dPrediction_period,
  vX,
  vT_x,
  vT_cal,
  vCovParams_trans,
  vCovParams_life,
  mCov_trans,
  mCov_life
)
}
\arguments{
\item{vEstimated_params}{Vector with the Pareto/NBD model parameters at original scale.}

\item{dPrediction_period}{time prediction time frame}

\item{vX}{Frequency vector of length n counting the numbers of purchases.}

\item{vT_x}{Recency vector of length n.}

\item{vT_cal}{Vector of length n indicating the total number of periods of observation.}

\item{vCovParams_trans}{Vector of estimated parameters for the transaction covariates.}

\item{vCovParams_life}{Vector of estimated parameters for the dropout covariates.}

\item{mCov_trans}{Matrix containing the covariates data affecting the transaction process. One column for each covariate.}

\item{mCov_life}{Matrix containing the covariates data affecting the lifetime process. One column for each covariate.}
}
\value{
Returns a vector containing the conditional expected transactions for the existing
customers in the Pareto/NBD model.
}
\description{
Calculates the expected number of transactions in a given time period based
on a customer's past transaction behavior and the Pareto/NBD model parameters.

\itemize{
\item{\code{pnbd_nocov_CET}}{ Conditional Expected Transactions without covariates}
\item{\code{pnbd_staticcov_CET}}{ Conditional Expected Transactions with static covariates}
}
}
\details{
\code{vEstimated_params} vector with the estimated parameters in original scale
for the Pareto/NBD model, namely (r, alpha, s, beta).
r and alpha: unobserved parameters that describe the NBD transaction process.
s and beta: unobserved parameters that describe the pareto
(exponential gamma) dropout process.

\code{mCov_trans} is a matrix containing the covariates data of
the time-invariant covariates that affect the transaction process.
Each column represents a different covariate. For every column a gamma parameter
needs to added to \code{vCovParams_trans} at the respective position.

\code{mCov_life} is a matrix containing the covariates data of
the time-invariant covariates that affect the lifetime process.
Each column represents a different covariate. For every column a gamma parameter
needs to added to \code{vCovParams_life} at the respective position.
}
\references{
Fader, Peter S., and Bruce G.S. Hardie (2005). "A Note on Deriving the
 Pareto/NBD Model and Related Expressions.", Web.
 \url{http://www.brucehardie.com/notes/008/}.
}
\keyword{internal}
