% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pnbd_DERT}
\alias{pnbd_DERT}
\alias{pnbd_nocov_DERT}
\alias{pnbd_staticcov_DERT}
\title{Pareto/NBD: Discounted Expected Residual Transactions}
\usage{
pnbd_nocov_DERT(
  vEstimated_params,
  continuous_discount_factor,
  vX,
  vT_x,
  vT_cal
)

pnbd_staticcov_DERT(
  vEstimated_params,
  continuous_discount_factor,
  vX,
  vT_x,
  vT_cal,
  mCov_life,
  mCov_trans,
  vCovParams_life,
  vCovParams_trans
)
}
\arguments{
\item{vEstimated_params}{Vector with the Pareto/NBD model parameters at original scale.}

\item{continuous_discount_factor}{continuous discount factor to use}

\item{vX}{Frequency vector of length n counting the numbers of purchases.}

\item{vT_x}{Recency vector of length n.}

\item{vT_cal}{Vector of length n indicating the total number of periods of observation.}

\item{mCov_life}{Matrix containing the covariates data affecting the lifetime process. One column for each covariate.}

\item{mCov_trans}{Matrix containing the covariates data affecting the transaction process. One column for each covariate.}

\item{vCovParams_life}{Vector of estimated parameters for the dropout covariates.}

\item{vCovParams_trans}{Vector of estimated parameters for the transaction covariates.}
}
\value{
Returns a vector with the DERT for each customer.
}
\description{
Calculates the discounted expected residual transactions.

\itemize{
\item{\code{pnbd_nocov_DERT}}{ Discounted expected residual transactions for the Pareto/NBD model without covariates}
\item{\code{pnbd_staticcov_DERT}}{ Discounted expected residual transactions for the Pareto/NBD model with static covariates}
}
}
\details{
\code{vEstimated_params} vector with the estimated parameters in original scale
for the Pareto/NBD model, namely (r, alpha, s, beta). \cr
r and alpha: unobserved parameters that describe the NBD transaction process. \cr
s and beta: unobserved parameters that describe the pareto
(exponential gamma) lifetime process.

\code{mCov_trans} is a matrix containing the covariates data of
the time-invariant covariates that affect the transaction process.
Each column represents a different covariate. For every column a gamma parameter
needs to added to \code{vCovParams_trans} at the respective position.

\code{mCov_life} is a matrix containing the covariates data of
the time-invariant covariates that affect the lifetime process.
Each column represents a different covariate. For every column a gamma parameter
needs to added to \code{vCovParams_life} at the respective position.
}
\references{
Fader, Peter S., and Bruce G.S. Hardie (2005). "A Note on Deriving the
Pareto/NBD Model and Related Expressions.", Web.
\url{http://www.brucehardie.com/notes/008/}.
}
