% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMF.R
\name{getCMFopts}
\alias{getCMFopts}
\title{Default options for CMF}
\usage{
getCMFopts()
}
\value{
Returns a list of:
\item{init.tau}{Initial value for the noise precisions. Only matters for
                Gaussian likelihood.}
\item{init.alpha}{Initial value for the automatic relevance determination
                  (ARD) prior precisions.}
\item{grad.reg }{The regularization parameter for the under-relaxed Newton
                 iterations. 0 = no regularization, larger values provide
                 increasing regularization. The value must be below 1.}
\item{gradIter}{How many gradient steps for updating the projections are
                 performed during each iteration of the whole algorithm.
                 Default is 1.}
\item{grad.max}{Maximum absolute change for the elements of the projection
                matrices during one gradient step. Small values help to
                prevent over-shooting, wheres inf results to no constraints.
                Default is \code{inf}.}
\item{iter.max }{Number of iterations for the whole algorithm.}
\item{computeCost}{Should the cost function values be computed or not.
                   Defaults to \code{TRUE}.}
\item{verbose}{0 = supress all printing, 1 = print current iteration and
               test RMSE every now and then, 2 = in addition to level 1
               print also the current gradient norm.}
\item{useBias}{Set this to \code{FALSE} to exclude the row and column
               bias terms. The default is \code{TRUE}.}
\item{method}{Default value of "gCMF" computes the CMF with group-sparsity.
              The other possible values are "CMF" for turning off the
              group-sparsity prior, and "GFA" for implementing group factor
              analysis (and canonical correlation analysis when
              \code{M = 2}).}
\item{prior.alpha_0}{Hyperprior values for the gamma prior for ARD.}
\item{prior.alpha_0t}{Hyperprior values for the gamma prior for tau.}
}
\description{
A helper function that creates a list of options to be passed
to \code{CMF}. To run the code with other option values, first
run this function and then directly modify the entries before
passing the list to \code{CMF}.
}
\details{
Most of the parameters are for controlling the optimization, but some will
alter the model itself. In particular, \code{useBias} is used for turning
the bias terms on and off, and \code{method} will change the prior for
\code{U}.

The default choice for \code{method} is \code{"gCMF"}, providing the
group-wise sparse CMF that identifies both shared and private factors
(see Klami et al. (2013) for details). The value \code{"CMF"} turns off
the group-wise sparsity, providing a CMF solution that attempts to learn
only factors shared by all matrices. Finally, \code{method="GFA"} implements
the group factor analysis (GFA) method, by fixing the variance of
\code{U[[1]]} to one and forcing \code{useBias=FALSE}. Then \code{U[[1]]}
can be interpreted as latent variables with unit variance and zero mean,
as assumed by GFA and CCA (special case of GFA with M=2). Note that as a
multi-view learning method \code{"GFA"} requires all matrices to share the
same rows, the very first entity set.
}
\examples{

CMF_options = getCMFopts()
CMF_options$iter.max = 500	# Change the number of iterations from default
                           # of 200 to 500.
CMF_options$useBias = FALSE # Do not take row and column means into
                            # consideration.
# These options will be in effect when CMF_options is passed on to CMF.

}
\references{
Arto Klami, Guillaume Bouchard, and Abhishek Tripathi.
Group-sparse embeddings in collective matrix factorization.
arXiv:1312.5921, 2014.

Seppo Virtanen, Arto Klami, Suleiman A. Khan, and Samuel Kaski.
Bayesian group factor analysis. In Proceedings of the 15th
International Conference on Artificial Intelligence and Statistics,
volume 22 of JMLR:W&CP, pages 1269-1277, 2012.
}
\seealso{
'CMF'
}
\author{
Arto Klami and Lauri Väre
}
