\name{matrix_to_triplets}
\alias{matrix_to_triplets}
\title{Conversion from matrix to coordinate/triplet format}
\usage{
matrix_to_triplets(orig)
}
\arguments{
  \item{orig}{A matrix of class \code{matrix}}
}
\value{
The input matrix in triplet/coordinate format.
}
\description{
The CMF code requires inputs to be speficied in a specific
sparse format. This function converts regular R matrices
into that format.
}
\details{
The element X[i,j] on the i:th row and j:t column is
represented as a triple (i,j,X[i,k]). The input for CMF is
then a matrix where each row specifies one element, and
hence the representation is of size Nx3, where N is the
total number of observed entries.

In the original input matrix the missing entries should be
marked as NA. In the output they will be completely
omitted.

Even though this format reminds the representation often
used for representing sparse matrices, it is important to
notice that observed zeroes are retained in the
representation. The elements missing from this
representation are considered unknown, not zero.
}
\examples{
x <- matrix(c(1,2,NA,NA,5,6),nrow=3)
triplet <- matrix_to_triplets(x)
print(triplet)
}
\author{
Arto Klami and Lauri Väre
}
\seealso{
\code{triplets_to_matrix}
}




