% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signedRescale.R
\name{signedRescale}
\alias{signedRescale}
\title{Rescale positive and negative data, preserving sign information.}
\usage{
signedRescale(
  matrix,
  global_max = NULL,
  global_min = NULL,
  global_sigma = NULL,
  global_mu = NULL,
  max_cap = NULL,
  method = "minmax",
  tan_transform = F,
  global_sigma_pos = NULL,
  global_sigma_neg = NULL,
  asymptotic_max = T
)
}
\arguments{
\item{matrix}{A matrix to be transformed}

\item{global_max}{the global maximum (used if scaling using statistics from a large matrix upon a submatrix).}

\item{global_min}{the global minimum}

\item{global_sigma}{the global signma}

\item{global_mu}{the global mu}

\item{max_cap}{the maximum saturation-- decreases the ceiling considered for the scaling function.
Useful to see greater differences if an image is too white, increase it if there is too much color to tell apart domains.}

\item{method}{method to perform the rescaling.
Options are "minmax" (default), "tan" for tangent, and "sd" for standard devation}

\item{tan_transform}{apply a tangent transformation?}

\item{global_sigma_pos}{The positive global sigma. See getGlobalRescalingStats.}

\item{global_sigma_neg}{The negative global sigma. See getGlobalRescalingStats.}

\item{asymptotic_max}{make the maximum value in the matrix not 1, but rather something slightly below.}
}
\value{
transformedmatrix A transformed matrix.
}
\description{
Performs a signed rescale on the data, shrinking the negative and positive ranges into the [0,1] space, such that negative is always less than 0.5 and positive is always greater.
}
\examples{
mat<-matrix(c(5,10,15,20,0,40,-45,300,-50),byrow=TRUE,nrow=3)
rescaled_mat<-signedRescale(mat)
mat
rescaled_mat<-signedRescale(abs(mat))
}
\keyword{matrix}
\keyword{negative}
\keyword{positive}
\keyword{rescale}
\keyword{signed}
