% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfuncs.R
\name{qTreat.coin}
\alias{qTreat.coin}
\title{Quick outlier treatment of a coin}
\usage{
\method{qTreat}{coin}(
  x,
  dset,
  winmax = 5,
  skew_thresh = 2,
  kurt_thresh = 3.5,
  f2 = "log_CT",
  ...
)
}
\arguments{
\item{x}{A coin}

\item{dset}{Name of data set to treat for outliers}

\item{winmax}{Maximum number of points to Winsorise for each indicator. Default 5.}

\item{skew_thresh}{Absolute skew threshold - default 2.}

\item{kurt_thresh}{Kurtosis threshold - default 3.5.}

\item{f2}{Function to call if Winsorisation does not bring skew and kurtosis within limits. Default \code{"log_CT"}.}

\item{...}{arguments passed to or from other methods.}
}
\value{
An updated coin with treated data set at \code{.$Data$Treated}.
}
\description{
A simplified version of \code{\link[=Treat]{Treat()}} which allows direct access to the default parameters. This has less flexibility,
but is an easier interface and probably more convenient if the objective is to use the default treatment process
but with some minor adjustments.
}
\details{
This function treats each indicator in the data set targeted by \code{dset} using the following process:
\itemize{
\item First, it checks whether skew and kurtosis are within the specified limits of \code{skew_thresh} and \code{kurt_thresh}
\item If the indicator is not within the limits, it applies the \code{\link[=winsorise]{winsorise()}} function, with maximum number of winsorised
points specified by \code{winmax}.
\item If winsorisation does not bring the indicator within the skew/kurtosis limits, it is instead passed to \code{f2}, which is
a second outlier treatment function, default \code{\link[=log_CT]{log_CT()}}.
}

The arguments of \code{\link[=qTreat]{qTreat()}} are passed to \code{\link[=Treat]{Treat()}}.

See \code{\link[=Treat]{Treat()}} documentation for more details, and \code{vignette("treat")}.
}
\examples{
# build example coin
coin <- build_example_coin(up_to = "new_coin", quietly = TRUE)

# treat with winmax = 3
coin <- qTreat(coin, dset = "Raw", winmax = 3)

}
