% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scatter.R
\name{plot_scatter}
\alias{plot_scatter}
\title{Scatter plot of two variables}
\usage{
plot_scatter(
  coin,
  dsets,
  iCodes,
  ...,
  by_group = NULL,
  alpha = 0.5,
  axes_label = "iCode",
  dset_label = TRUE,
  point_label = NULL,
  check_overlap = TRUE,
  nudge_y = 5,
  log_scale = c(FALSE, FALSE)
)
}
\arguments{
\item{coin}{A coin object}

\item{dsets}{A 2-length character vector specifying the data sets to extract v1 and v2 from,
respectively (passed as \code{dset} argument to \code{\link[=get_data]{get_data()}}. Alternatively specify as a single string
which will be used for both x and y.}

\item{iCodes}{A 2-length character vector specifying the \code{iCodes} to use as v1 and v2,
respectively (passed as \code{iCodes} argument to \code{\link[=get_data]{get_data()}}. Alternatively specify as a single string
which will be used for both x and y.}

\item{...}{Optional further arguments to be passed to \code{\link[=get_data]{get_data()}}, e.g. to specify which \code{uCode}s to plot.}

\item{by_group}{A string specifying an optional group variable. If specified, the plot will be
coloured by this grouping variable.}

\item{alpha}{Transparency value for points between 0 and 1, passed to ggplot2.}

\item{axes_label}{A string specifying how to label axes and legend. Either \code{"iCode"} to use the respective codes
of each variable, or else \code{"iName"} to use the names (as specified in \code{iMeta}).}

\item{dset_label}{Logical: if \code{TRUE} (default), also adds to the axis labels which data set each variable is from.}

\item{point_label}{Specifies whether and how to label points. If \code{"uCode"}, points are labelled with their unit codes,
else if \code{"uName"}, points are labelled with their unit names. Set \code{NULL} to remove labels (default).}

\item{check_overlap}{Logical: if \code{TRUE} (default), point labels that overlap are removed - this results in a legible
plot but some labels may be missing. Else if \code{FALSE}, all labels are plotted.}

\item{nudge_y}{Parameter passed to ggplot which controls the vertical adjustment of the text labels if present.}

\item{log_scale}{A 2-length logical vector specifying whether to use log axes for x and y respectively: if \code{TRUE},
a log axis will be used. Defaults to not-log.}
}
\value{
A ggplot2 object.
}
\description{
This is a convenient quick scatter plot function for plotting any two variables x and y in a coin against each other.
At a minimum, you must specify the data set and iCode of both x and y using the \code{dsets} and \code{iCodes} arguments.
}
\details{
Optionally, the scatter plot can be coloured by grouping variables specified in the coin (see \code{by_group}). Points
and axes can be labelled using other arguments.

This function is powered by ggplot2 and outputs a ggplot2 object. To further customise the plot, assign the output
of this function to a variable and use ggplot2 commands to further edit. See \verb{vignette("visualisation}) for more details on plotting.
}
\examples{
# build example coin
coin <- build_example_coin(up_to = "new_coin")

# scatter plot of Flights against Population
# coloured by GDP per capita
# log scale applied to population
plot_scatter(coin, dsets = c("uMeta", "Raw"),
             iCodes = c("Population", "Flights"),
             by_group = "GDPpc_group", log_scale = c(TRUE, FALSE))


}
