% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{calculateSynergy}
\alias{calculateSynergy}
\title{Function calculates significant synergy/antagonism in experimental data as per Bliss or Loewe model.}
\usage{
calculateSynergy(filename, sheet, model, inputFormates, platetype = "384",
  keyposition = 2, selectionkey = "65000", platekey = 7051,
  minThersholdForCVCal = 0.15, minThersholdForCV = 0.3, wells,
  yConcentration, xConcentration, xDrug, yDrug, cellLine,
  survivalFunc = function(x, y, z) {     (x - z)/(y - z) }, nBoot = 2500)
}
\arguments{
\item{filename}{Name of data file.}

\item{sheet}{Optional, sheet number if spreadsheet file is used for input.}

\item{model}{bliss or loewe.}

\item{inputFormates}{Any of the three c("fmca","macsynergy","others").}

\item{platetype}{Optional default is 384.}

\item{keyposition}{Optional default is 2.}

\item{selectionkey}{Optional default is 65000.}

\item{platekey}{Optional barcode.}

\item{minThersholdForCVCal}{Optional default is 0.15.}

\item{minThersholdForCV}{Optional default is 0.3.}

\item{wells}{Defines thes experiment layout in the well ranges, these ranges should  be in triplet form that is
1-control wells range, 2-empty wells range and 3-case wells range. An experiment
can have multiple replicates thus having multiple triplicates of well ranges.}

\item{yConcentration}{Y drug concentrations.}

\item{xConcentration}{X drug concentrations.}

\item{xDrug}{X drug name.}

\item{yDrug}{Y drug name.}

\item{cellLine}{Cell line/experiment name.}

\item{survivalFunc}{Optional default is function (x,y,z) {(x-z)/(y-z)}
where x is combination/drug treatment outcome, y is the untreated control and
z is the background noise.}

\item{nBoot}{Optional Number of time to bootstrap.}
}
\value{
Store and print graphs/data of synergy/antagonism analyses.
}
\description{
Function calculates significant synergy/antagonism in experimental data as per Bliss or Loewe model.
}
\examples{
fl <- system.file("/raw/testData.xls", package="COMBIA")
wellR <- list(c("l3:l10","m3:m10","b3:k10", "l13:l20","m13:m20","b13:k20",
           "l23:l30","m23:m30","b23:k30", "l33:l40","m33:m40","b33:k40") )
sh <- 1
mdl <- "bliss"
xConc <- c(0.00,  0.20,  0.39,  0.78,  1.56,  3.12,  6.25, 12.50, 25.00, 50)
yConc <- c(128,  64,  32,  16,   8,   4,   2,   0)
xDrug <- "A"
yDrug <- "B"
cellLine <-"Cell"
calculateSynergy(filename = c(fl), sheet=1, model="bliss", inputFormates="macsynergy",
                 wells=wellR, yConcentration= yConc, xConcentration=xConc,
                 xDrug=xDrug, yDrug=yDrug,cellLine=cellLine, nBoot=1000)
}
\author{
Muhammad kashif
}

